<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimRuleParticipantTable extends Migration
{
    protected $tableName = 'claim_rule_participant';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('rule_id');
            $table->string('participant_type', 100);
            $table->timestamps();
            $table->foreign('rule_id')->references('id')->on('claim_rule');
            $table->unique(['rule_id', 'participant_type']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
