<?php

namespace Ignite\Claim\Database\Seeders;

use Ignite\Core\Database\Seeders\AbstractSeeder;
use Ignite\Claim\Entities\OfferCampaign;

class OfferCampaignTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        //$offerCampaignRepository = app(OfferCampaignRepository::class);
        $strategy = $this->strategy('json', [
            'filepath' => realpath(__DIR__ . '/../Data/offer_campaigns.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        //OfferCampaign::truncate();

        foreach ($sources as $source) {
            try {
                OfferCampaign::create($source);
            } catch (\Exception $e) {
                //echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
