@php
    $line = $formData['claim_items'] ?? [];
    $selectedData = collect($line);
    $selected = $selectedData->pluck('offer_id')->toArray();
    $selectedNames = $selectedData->pluck('name')->toArray();
@endphp
<input type="hidden" id="claimItemAction" value="">
<div class="row">
    @if (count($offerGroups) > 1)
        <div class="form-group col-md-6">
            <label for="claimItemOfferGroup">{{ __('Claim::claim.items.group') }} <em class="field-is-required text-danger">*</em></label>
            <select style="display: block; width: 100%;" class="form-control" name="claim_items[0][offer_group]" id="claimItemOfferGroup" data-name="offer_group" required>
                <option value="">{{ __('Core::core.select.default') }}</option>
                @foreach($offerGroups as $name => $offerGroup)
                    <option {{ in_array($offer['offer_id'], $selected) ? ' selected' : '' }} value="{{ $name }}">{{ $name }}</option>
                @endforeach
            </select>
        </div>
    @else
        @php $groups = array_keys($offerGroups); @endphp
        <input type="hidden" name="claim_items[0][offer_group]" id="claimItemOfferGroup" data-name="offer_group" value="{{ $groups[0] }}" readonly required />
    @endif
    <div class="form-group col-md-{{ count($offerGroups) > 1 ? 6 : 12 }}">
        <label for="claimItemName">{{ __('Claim::claim.items.name') }} <em class="field-is-required text-danger">*</em></label>
        @if (count($offerGroups) > 1)
            <select data-tags="false" data-close-on-select="false" data-maximum-selection-length="{{ $formData['maxLineitems'] ?? 5 }}" data-placeholder="Please select the products that apply" multiple style="display: block; width: 100%;" class="form-control" name="claim_items[0][offer_id][]" id="claimItemName" data-name="name" required>
                @if (isset($line['offer_group']) && isset($offerGroups[$line['offer_group']]))
                    @foreach ($offerGroups[$line['offer_group']] as $offer)
                        <option {{ in_array($offer['offer_id'], $selected) ? ' selected' : '' }} value="{{ $offer['offer_id'] }}">{{ $offer['name'] }}</option>
                    @endforeach
                @endif
            </select>
        @else
            @php $groups = array_keys($offerGroups); @endphp
            @if (isset($offerGroups[$groups[0]]) && count($offerGroups[$groups[0]]) > 1)
                <select data-allow-clear="true" data-tags="false" data-close-on-select="false" data-maximum-selection-length="{{ $formData['maxLineitems'] ?? 5 }}" data-placeholder="Please select all that apply" multiple style="display: block; width: 100%;" class="form-control" name="claim_items[0][offer_id][]" id="claimItemName" data-name="name" required>
                    @foreach ($offerGroups[$groups[0]] as $offer)
                        <option data-offer-id="{{ $offer['offer_id'] }}" data-selected="{{ implode(',', $selected) }}" {{ in_array($offer['offer_id'], $selected) ? ' selected' : '' }} value="{{ $offer['offer_id'] }}">{{ $offer['name'] }}</option>
                    @endforeach
                </select>
            @else
                {{-- TODO: Figure out what to do when no group can be found --}}
                <input type="text" class="form-control" name="claim_items[0][offer_id]" id="claimItemName" data-name="name" value="" readonly required />
            @endif
        @endif
        <input type="hidden" class="form-control" id="claimItemId" name="claim_items[0][id]" data-name="id" value="{{ isset($line['id']) ? $line['id'] : 'new' }}" />
        <input type="hidden" class="form-control" id="claimItemOfferId" name="claim_items[0][offer_id]" data-name="offer_id" value="{{ implode(',', $selected) }}" />
        <input type="hidden" class="form-control" id="claimItemOfferName" name="claim_items[0][name]" data-name="name" value="{{ implode('|', $selectedNames) }}" />
        <input type="hidden" class="form-control" id="claimItemQty" name="claim_items[0][qty]" data-name="qty" value="{{ isset($line['qty']) ? $line['qty'] : 1 }}" />
    </div>
</div>
