@extends('Claim::admin.offers.layouts.master')

@section('breadcrumb')
    @parent
    <li>Offer</li>
    <li class="active">Campaigns</li>
@endsection

@section('tab_buttons')
@endsection

@section('tab_content')
    <div class="form-inline offer-functions clearfix">
        <button type="button" class="btn btn-sm btn-primary pull-right" data-toggle="modal" data-target="#campaignEditDialog" data-campaign_id="new">New Campaign</button>
    </div>

    <table class="table table-bordered table-striped table-responsive table-data">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Descripton</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Status</th>
                <th>&nbsp;</th>
            </tr>
        </thead>
        <tbody>
        @forelse ($campaigns as $campaign)
            <tr data-campaign_id="{{ $campaign['id'] }}">
                <td class="campaignDetails">{{ $campaign['id'] }}</td>
                <td class="campaignDetails">{{ $campaign['name'] }}</td>
                <td class="campaignDetails" title="Click for Promotion Details.">{{ $campaign['description'] }}</td>
                <td class="campaignDetails">{{ Format::date($campaign['start_date']) }}</td>
                <td class="campaignDetails">{{ Format::date($campaign['end_date']) }}</td>
                <td class="campaignDetails">{{ ($campaign['status'] == 1) ? 'active' : '' }}</td>
                <td>
                    <button type="button" class="btn btn-sm btn-default" data-toggle="modal" data-target="#campaignEditDialog" data-campaign_id="{{ $campaign['id'] }}" data-campaign_action="edit" >
                        Edit
                    </button>
                    @if ( empty($campaign['has_promotions']) && $campaign['id'] > 1 )
                        <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#campaignEditDialog" data-campaign_id="{{ $campaign['id'] }}" data-campaign_action="delete" >
                            Delete
                        </button>
                    @endif
                </td>
            </tr>
            <tr class="promotionRow" data-campaign_id="{{ $campaign['id'] }}">
                <td colspan="10">
                    <table class="table table-striped table-bordered">
                        @if (count($campaign['promotions']) > 0 )
                            <tr class="promotionDetails">
                                <th>#</th>
                                <th>Name</th>
                                <th>Start Date</th>
                                <th>End Date</th>
                                <th>Status</th>
                            </tr>
                            @foreach($campaign['promotions'] as $promotion)
                                <tr class="promotionDetails">
                                    <td>{{ $promotion['id'] }}</td>
                                    <td>{{ $promotion['name'] }}</td>
                                    <td>{{ $promotion['start_date'] }}</td>
                                    <td>{{ $promotion['start_date'] }}</td>
                                    <td>{{ $promotion['status'] }}</td>
                                </tr>
                            @endforeach <!-- campaign->permissions -->
                        @else
                            <tr class="promotionDetails">
                                <td colspan="10" class="text-center text-danger">No permissions defined.</td>
                            </tr>
                        @endif
                    </table>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="10" class="text-center text-danger">No campaigns defined.</td>
            </tr>
        @endif
        </tbody>
    </table>

    <!-- Modal -->
    <div class="modal" id="campaignEditDialog" tabindex="-1" role="dialog" aria-labelledby="campaignEditLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="campaignEditLabel">Maintain Campaign</h2>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form>
                        {{ csrf_field() }}
                        <input type="hidden" id="campaignId" value="">
                        <input type="hidden" id="campaignAction" value="">

                        <div class="form-group">
                            <label for="campaignName">Name</label>
                            <input class="form-control" id="campaignName" placeholder="Enter Campaign Name">
                        </div>
                        <div class="form-group">
                            <label for="campaignDescription">Description</label>
                            <textarea class="form-control" id="campaignDescription" rows="3"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="campaignStartDate">Start Date</label>
                            <input type="text" id="campaignStartDate" class="form-control datepicker" />
                        </div>

                        <div class="form-group">
                            <label for="campaignEndDate">End Date</label>
                            <input type="text" id="campaignEndDate" class="form-control datepicker" />
                        </div>

                        <div class="form-check">
                            <label class="form-check-label">
                                <input type="checkbox" class="form-check-input" id="campaignStatus" value="1">
                                Active
                            </label>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="campaignSave">Save</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
    @parent

    <script>

        $(document).ready(function(){

            function clearCampaignDialog()
            {
                $('#campaignName').val('');
                $('#campaignDescription').val('');
                $('#campaignStartDate').val('');
                $('#campaignEndDate').val('');
                $('#campaignStatus').prop('checked', true);
            }

            function populateCampaignDialog(campaignId)
            {
                $.ajax({
                    type: 'GET',
                    url: '/offer/api/campaign/get/' + campaignId,
                    dataType: 'json',
                    success: function(result){
                        var campaign = result.data;
                        var startDate = ( parseInt(campaign.start_date) > 0 ) ? moment(campaign.start_date).format('M/D/YYYY') : '';
                        var endDate = ( parseInt(campaign.end_date) > 0 ) ? moment(campaign.end_date).format('M/D/YYYY') : '';
                        $('#campaignName').val(campaign.name);
                        $('#campaignDescription').val(campaign.description);
                        $('#campaignStartDate').val(startDate);
                        $('#campaignEndDate').val(endDate);
                        if ( campaign.status == 1 )
                            $('#campaignStatus').prop('checked', true);
                        else
                            $('#campaignStatus').prop('checked', false);

                        $('.datepicker').each(function() {
                            $(this).datepicker('update');
                        });
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert('Unable to Get Campaign for id = ' + campaignId + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            function saveCampaign()
            {
                var campaignId = $('#campaignId').val();

                var data = {};
                data._token = $('[name=_token]').val();
                data.id = $('#campaignId').val();
                data.name = $('#campaignName').val();
                data.description = $('#campaignDescription').val();
                data.start_date = $('#campaignStartDate').val();
                data.end_date = $('#campaignEndDate').val();
                data.status = ($('#campaignStatus').prop('checked')) ? 1 : 0;

                $.ajax({
                    type: 'POST',
                    url: '/offer/api/campaign/store',
                    data: data,
                    dataType: 'json',
                    success: function(result){
                        var campaign = result.data;
                        $("#campaignEditDialog").modal('hide');
                        location.reload();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert('Unable to Update Campaign id = ' + campaignId + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            function deleteCampaign()
            {
                var data = {};
                data._token = $('[name=_token]').val();
                data.id = $('#campaignId').val();

                $.ajax({
                    type: 'POST',
                    url: '/offer/api/campaign/delete',
                    data: data,
                    dataType: 'json',
                    success: function(result){
                        var campaign = result.data;
                        $("#campaignEditDialog").modal('hide');
                        location.reload();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert('Unable to Delete Campaign id = ' + campaignId + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            $('#campaignEditDialog').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget); // Button that triggered the modal
                // Extract action from data-* attributes
                var action = button.data('campaign_action');
                var campaignId = button.data('campaign_id');

                $('#campaignId').val(campaignId);

                $('.modal-header').removeClass('bg-info');
                $('.modal-header').removeClass('bg-success');
                $('.modal-header').removeClass('bg-danger');

                if ( action == 'delete' ) {
                    $('#campaignEditLabel').html('DELETE Campaign');
                    $('#campaignAction').val('delete');
                    $('#campaignSave').html('Delete');
                    $('.modal-header').addClass('bg-danger');
                    populateCampaignDialog(campaignId);
                }
                else {
                    if ( campaignId == 'new' ) {
                        $('#campaignEditLabel').html('ADD New Campaign');
                        $('#campaignAction').val('new');
                        $('#campaignSave').html('Create');
                        $('.modal-header').addClass('bg-success');
                        clearCampaignDialog(campaignId);
                    }
                    else {
                        $('#campaignEditLabel').html('EDIT Campaign');
                        $('#campaignAction').val('update');
                        $('#campaignSave').html('Update');
                        $('.modal-header').addClass('bg-default');
                        populateCampaignDialog(campaignId);
                    }
                }
            });

            $('#campaignSave').click(function (event) {
                var action = $('#campaignAction').val();

                if ( action == 'delete' )
                    deleteCampaign();
                else
                    saveCampaign();
            });

            $('.campaignDetails').click(function(event) {
                var campaignId = $(this).parent().attr('data-campaign_id');
                $( '.promotionRow[data-campaign_id=' + campaignId + ']' ).toggle();
            });

            $('.datepicker').datepicker({
                format: 'mm/dd/yyyy',
                autoclose: true
            }).on('show.bs.modal', function(event) {
                // Prevent ditepicker from firing bootstrap modal "show.bs.modal"
                event.stopPropagation();
            });
        });  // document ready

    </script>

@endsection
