<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class RuleValue extends Model
{
	use ValidatesFields;

	/**
	 * The table name.
	 * @var string
	 */
	protected $table = 'claim_rule_value';

	/**
	 * The primary key.
	 * @var string
	 */
	protected $primaryKey = 'id';

	/**
	 * The field declarations.
	 * @var array
	 */
    public static $fields = [
        'id'               => ['type' => 'integer'],
        'rule_id'          => ['type' => 'integer'],
        'participant_type' => ['type' => 'string'],
        'value_type_id'    => ['type' => 'integer', 'default' => '1'],
        'value'            => ['type' => 'float', 'default' => '0'],
    ];

	/**
	 * The value type declarations.
	 * @var array
	 */
    public static $valueTypes = [
        '1'     => 'Amount',
        '2'     => 'Percent',
	];

	/**
	 * The relationship type declarations.
	 * @var array
	 */
    public static $relationTypes = [
        '1'     => 'Participant',
	];

	/**
	 * The relationship to the Rule model.
	 *
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
    public function rule()
    {
        return $this->belongsTo(Rule::class, 'rule_id');
    }
}
