<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class OfferValue extends Model
{
	use ValidatesFields;

	const OFFER_TYPE_FIXED = 1;
    const OFFER_TYPE_PERCENT = 2;

	/** @var string */
    protected $table = 'claim_offer_value';

    /** @var string */
    protected $primaryKey = 'id';

    /** @var array */
    public static $fields = [
        'id'               => ['type' => 'integer'],
        'offer_id'         => ['type' => 'integer'],
        'participant_type' => ['type' => 'string'],
        'value_type_id'    => ['type' => 'integer', 'default' => '1'],
        'value'            => ['type' => 'float', 'default' => '0'],
    ];

    /**
     * The relationship to the offer.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function offer()
    {
        return $this->belongsTo(Offer::class, 'offer_id');
    }
}
