<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimOfferTable extends Migration
{
    protected $tableName = 'claim_offer';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('promotion_id');
            $table->string('name', 100);
            $table->string('description', 500)->nullable();
            $table->dateTime('start_date')->nullable();
            $table->dateTime('end_date')->nullable();
            $table->dateTime('grace_date')->nullable();
            $table->integer('show_order')->default(0);
            $table->string('offer_number', 255)->nullable();
            $table->string('offer_group', 255)->nullable();
            $table->string('sku', 255)->nullable();
            $table->string('type', 255)->nullable();
            $table->integer('value_mode_id')->default(1);
            $table->integer('value_type_id')->default(1);
            $table->integer('value')->default(0);
            $table->integer('status')->default(1);
            $table->integer('archived')->default(0);
            $table->timestamps();
            $table->foreign('promotion_id', 'o_promotion_foreign')->references('id')->on('claim_offer_promotion');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
