<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimParticipantTable extends Migration
{
    protected $tableName = 'claim_participant';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('claim_id');
            $table->unsignedInteger('user_id')->nullable();
            $table->string('participant_email')->nullable()->default(null);
            $table->string('participant_type')->nullable()->default(null);
            $table->dateTime('date_submitted')->nullable();
            $table->dateTime('date_approved')->nullable();
            $table->dateTime('date_declined')->nullable();
            $table->dateTime('date_issued')->nullable();
            $table->dateTime('date_canceled')->nullable();
            $table->double('value')->nullable()->default(0);
            $table->double('value_adjust')->nullable()->default(0);
            $table->double('value_calculated')->nullable()->default(0);
            $table->string('reason_declined', 500)->nullable();
            $table->text('internal_notes', 500)->nullable();
            $table->text('external_notes', 500)->nullable();
            $table->string('status', 25);
            $table->softDeletes('deleted_at');
            $table->timestamps();
            $table->foreign('claim_id')->references('id')->on('claim')->onDelete('cascade');
            $table->foreign('user_id')->references('user_id')->on('core_user');
            $table->unique(['claim_id', 'user_id'], 'claim_user');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
