@extends('Core::layouts.main')

@section('meta_title', 'Claim Management')

@section('css')
    @parent
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/>
@endsection

@php
    $activeKey = request()->segment(4);
    $tabs = [
        'all'       => 'All Claims',
        'pending'   => 'Pending Claims',
        'approved'  => 'Approved Claims',
        'issued'    => 'Issued Claims',
        'declined'  => 'Declined Claims',
        'cancelled' => 'Cancelled Claims',
    ];
@endphp

@section('heading')
    <h1>
        @if (! empty($user))
            {{ $tabs[$activeKey] }} for&nbsp;{{ $user['first'] . ' ' . $user['last'] }}
            <a type="button" class="btn btn-default btn-sm" href="{{ '/admin/claim/list/' . $activeKey }}">All Users</a>
        @else
            {{ $tabs[$activeKey] }} for All Users
        @endif
        <small><a href="{{ url('/admin/claim/list') }}">Claim Management</a></small>
    </h1>
@endsection

@section('breadcrumb')
    @parent
    <li><a href="/admin/claim">Claims</a></li>
    <li class="active">{{ $tabs[$activeKey] }}</li>
@endsection

@section('page_content')
    <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
            @foreach($tabs as $tabKey => $tabLabel)
                <li class="{{ (strtolower($activeKey) == $tabKey) ? 'active' : '' }}">
                    <a href="/admin/claim/list/{{ $tabKey .'/' .  (( ! empty($userId) ) ? $userId : '')  }}">{{ $tabLabel }}</a>
                </li>
            @endforeach
        </ul>
        <div class="tab-content">
            @yield('tab_content')
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
@endsection
