@extends('Claim::layouts.entry')

@php
    $current = empty($current) ? 'active' : $current;
    $pageTitle = 'Trashed Claim Participants';
@endphp

@section('page_heading', $pageTitle)
@section('page_breadcrumb', $pageTitle)

@section('page_content')
    <div class="box box-primary">
        <div class="box-body">
            {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
            <form id="claim-restore-form" action="{{ route('admin.claim.restore') }}" method="post">
                {{ csrf_field() }}
                {{ method_field('PUT') }}
                <input type="hidden" name="ids" value="" id="claim-restore-field" />
            </form>
            <form id="claim-shred-form" action="{{ route('admin.claim.shred') }}" method="post">
                {{ csrf_field() }}
                {{ method_field('DELETE') }}
                <input type="hidden" name="ids" value="" id="claim-shred-field" />
            </form>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <!--script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script-->
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    enabled: false,
                    text: '<span class="fa fa-recycle text-success"></span> <span class="text-success">Restore</span>',
                    action: function (e, dt, node, conf) {
                        var selected = dt.column(0).checkboxes.selected();
                        var message = 'You are about to restore ' + selected.length + ' record(s). Are you sure you wish to proceed?';
                        if (confirm(message)) {
                            $('#claim-restore-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                            $('#claim-restore-form').submit();
                        }
                    }
                }, {
                    enabled: false,
                    text: '<span class="fa fa-times text-danger"></span> <span class="text-danger">Permanently Delete</span>',
                    action: function (e, dt, node, conf) {
                        var selected = dt.column(0).checkboxes.selected();
                        var message = 'You are about to permanently delete ' + selected.length + ' record(s). Are you sure you wish to proceed?';
                        if (confirm(message)) {
                            $('#claim-shred-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                            $('#claim-shred-form').submit();
                        }
                    }
                }]
            });
        });
    </script>
@endsection

