<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimFileTable extends Migration
{
    protected $tableName = 'claim_file';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->string('related_type', 50);
            $table->string('related_name', 100);
            $table->integer('related_id');
            $table->string('file_name', 255);
            $table->string('file_ext', 10);
            $table->string('original_name', 255);
            $table->string('original_ext', 10);
            $table->string('tags', 100);
            $table->string('location_type', 20);
            $table->string('location_path_setting', 50);
            $table->integer('user_id');
            $table->integer('login_user_id');
            $table->string('short_description', 100);
            $table->string('description', 255);
            $table->timestamps();
            $table->index('user_id');
            $table->index('login_user_id');
            $table->index(['related_type', 'related_name', 'related_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
