(function($, window, document, undefined) {

    'use strict';

    window.SelectedButtons = function(options) {
        return {
            settings: $.extend({
                container: '.dt-buttons',
                status: '#selected-status',
                form: 'form#selected'
            }, options),
            init: function(statuses) {
                for (var status in statuses) {
                    if (statuses.hasOwnProperty(status)) {
                        var settings = statuses[status];
                        this._build(status, settings);
                    }
                }
            },
            _build: function(status, options) {
                var settings = $.extend({
                    label: '',
                    text: 'text-gray',
                    type: 'default',
                    icon: '',
                    callback: false
                }, options);

                var icon = this._buildIcon(settings.icon);
                var label = this._buildLabel(settings.text, settings.label, icon);
                var labelText = (settings.icon.length ? ' ' : '') + settings.label;
                var button = this._buildButton(settings.type, settings.label);
                label.append(icon).append($('<span></span>').text(labelText));
                button.append(label).on('click', $.proxy(function(evt) {
                    evt.preventDefault();
                    this._handler.apply(this, [button, status, settings.callback, evt]);
                }, this));
                this._append(button);

                return button;
            },
            _buildIcon: function(icon) {
                if (! icon.length) {
                    return '';
                }
                return $('<i></i>', {'class': 'fa fa-' + icon});
            },
            _buildLabel: function(className) {
                return $('<span></span>', {'class': className});
            },
            _buildButton: function(type, label) {
                var classes = [
                    'btn',
                    'btn-status',
                    'disabled',
                    'btn-' + type.toLowerCase().replace(' ', '-'),
                    'btn-' + label.toLowerCase().replace(' ', '-')
                ];

                return $('<button></button>', {
                    'class': classes.join(' '),
                    'disabled': 'disabled'
                });
            },
            _append: function($button) {
                $(this.settings.container).append($button);
            },
            _handler: function(button, status, callback, evt) {
                if (callback) {
                    callback.apply(this, [button, status, evt]);
                } else {
                    this.submit(status);
                }
            },
            submit: function(status) {
                $(this.settings.status).val(status);
                $(this.settings.form).submit();
            },
            toggle: function(on) {
                return this['toggle' + (on ? 'On' : 'Off')]();
            },
            toggleOn: function() {
                return $(this.settings.container).find('.btn-status')
                    .removeClass('disabled')
                    .prop('disabled', false).removeProp('disabled');
            },
            toggleOff: function() {
                return $(this.settings.container).find('.btn-status')
                    .addClass('disabled')
                    .prop('disabled', true);
            }
        };
    };

})(window.jQuery, window, document);
