@extends('Claim::layouts.entry')

@section('page_heading', 'View Claim #' . $formData['id'])
@section('page_breadcrumb', 'View Claim #' . $formData['id'])

@section('page_content')
    <div class="row">
        <div class="col-md-3">
            @include('Claim::admin.partials.menu', ['formData' => $formData])
            @include('Claim::admin.partials.participant', ['participant' => $formData['claim_participant']['participant']])
        </div>
        <div class="col-sm-9">
            <div class="box box-primary">
                <div class="box-body">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="panel-title">
                                <strong>External Fields</strong>
                            </div>
                        </div>
                        <div class="panel-body">
                            @include('Claim::partials.claimReviewFieldsExternal')
                        </div>
                    </div>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="panel-title">
                                <strong>Internal (Claim Participant) Fields</strong>
                            </div>
                        </div>
                        <div class="panel-body">
                            @include('Claim::partials.claimReviewFieldsInternal')
                        </div>
                    </div>
                    @include('Claim::partials.claimReviewItems_static')

                    @if ( ! empty($documentTypes) )
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="panel-title"><strong>Supporting Documents</strong></div>
                        </div>
                        <div class="panel-body">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>Document Type</th>
                                    <th>Link</th>
                                    <th>Date</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($formData['documents'] as $document)
                                    <tr class="">
                                        <td>{{ $document['tags'] }}</td>
                                        <td><a href="/file/download/{{ scramble()->scramble('claim-' . $document['related_id'] . '-' . $document['id']) }}" target="_blank">{{ $document['original_name'] }}</a></td>
                                        <td>{{ Format::date($document['created_at']) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center text-danger">No documents submitted.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif

                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="panel-title"><strong>Notes</strong></div>
                        </div>
                        <div class="panel-body">
                            <form class="form-horizontal" id="claimNotesForm" method="post" action="/admin/claim/addnote">
                                {{ csrf_field() }}
                                <input type="hidden" id="user_id" name="user_id" value="{{ $formData['claim_participant']['id'] }}" />
                                <input type="hidden" id="claim_id" name="claim_id" value="{{ $formData['id'] }}" />
                                <div class="form-group">
                                    <label class="form col-md-2">Add Note:</label>
                                    <div class="col-md-8">
                                        <textarea class="form-control" id="add_note" name="add_note" rows="5"></textarea>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="form col-md-2">&nbsp;</label>
                                    <div class="col-md-8">
                                        <button type="submit" class="btn btn-md btn-info">Add</button>
                                    </div>
                                </div>
                            </form>
                            <hr />
                            <table class="table table-responsive">
                                <thead>
                                <tr>
                                    <th>Date/Time</th>
                                    <th>Entered By</th>
                                    <th>Note</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($notes as $note)
                                    <tr>
                                        <td>{{ Format::date($note['created_at']) }}</td>
                                        <td>{{ $note['added_by']['first'] . ' ' . $note['added_by']['last'] }}</td>
                                        <td>{{ $note['message'] }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="panel-title"><strong>History</strong></div>
                        </div>
                        <div class="panel-body">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Date/Time</th>
                                        <th>Changed By</th>
                                        <th>Note</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($histories as $history)
                                    @include('Claim::partials.history.records', [
                                        'history' => $history,
                                        'data' => $formData
                                    ])
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    @if(! empty($ruleLog))
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="panel-title"><strong>Rule Log</strong></div>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-10 text-center" style="padding-top: 5px; padding-bottom: 5px;">
                                    <textarea class="form-control" cols="100" rows="10" disabled="disabled">{{ $ruleLog['log_text'] }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection