@extends('Core::layouts.participant')

@section('page_heading', $pageTitle = sprintf('#%s - %s', $participant->getId(), $name = $participant->getFullName()))
@section('page_breadcrumb', $pageTitle)

@section('page_content')
    <div class="form-horizontal">
        <div class="row form-affix-container">
            @include('Core::partials.menu')
            <div class="col-sm-9 form-affix-body">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h2 class="box-title">{{ $name }}'{{ ends_with($name, 's') ? '' : 's' }} Claims</h2>
                    </div>
                    <div class="box-body">
                        {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            $.deleteEntry({
                confirmation: 'Are you sure you want to delete this claim participant?',
                request: { method: 'GET', type: 'json' },
                onSuccess: function(button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function() {
                            $(this).remove();
                            $('#dataTableBuilder').DataTable().ajax.reload();
                        });
                }
            });
        });
    </script>
@endsection
