<?php

namespace Ignite\Claim\Events\Handlers\Menus;

use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Ignite\Core\Models\Menu\Item;
use Ignite\Core\Models\Menu\NavigationMenu;

class AddClaimItemsToNavigationMenu
{
    /**
     * Handle the event.
     *
     * @param NavigationMenuPreCompile|UserMenuPreCompile $event
     */
    public function handle($event)
    {
        /** @var NavigationMenu $manager */
        $manager = $event->getManager();
        $item = new Item(url('/claim'), 'My Claims', 30);

        if ($manager->has('/participant/profile') && $event instanceof NavigationMenuPreCompile) {
            $manager->get('/participant/profile')->addChild($item);
        }

        if ($event instanceof UserMenuPreCompile) {
            $manager->add($item);
        }
    }
}
