<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimOfferUserPromotionGroupTable extends Migration
{
    protected $tableName = 'claim_offer_user_promotion_group';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id');
            $table->unsignedInteger('promotion_group_id');
            $table->timestamps();
            $table->unique(['user_id', 'promotion_group_id'], 'coupg_user');
            $table->foreign('user_id', 'oupg_user_foreign')->references('user_id')->on('core_user');
            $table->foreign('promotion_group_id', 'oupg_promotion_group_foreign')->references('id')->on('claim_offer_promotion_group');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
