@extends('Claim::admin.offers.layouts.master')

@section('page_heading', 'Promotion Groups')
@section('page_breadcrumb', 'Promotion Groups')

@section('tab_content')
    <div class="row">
        <div class="col-xs-4">
            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#promotionGroupEditDialog" data-promotion_group_id="new"><span class="fa fa-plus text-success"></span> <span class="text-success">Create</span></button>
        </div>
    </div>
    <hr />
    <table class="table table-bordered table-striped table-responsive table-data">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Description</th>
                <th>Status</th>
                <th>&nbsp;</th>
            </tr>
        </thead>
        <tbody>
        @if (count($promotionGroups) > 0 )
            @foreach($promotionGroups as $promotionGroup)

                <tr data-promotion_group_id="{{ $promotionGroup['id'] }}">
                    <td nowrap width="120">
                        <button type="button" class="btn btn-sm btn-default" data-toggle="modal" data-target="#promotionGroupEditDialog" data-promotion_group_id="{{ $promotionGroup['id'] }}" data-promotion_group_action="edit" >
                            Edit
                        </button>
                        <button {{ (empty($promotionGroup['has_promotions']) && $promotionGroup['id'] > 1) ? '' : 'disabled' }} type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#promotionGroupEditDialog" data-promotion_group_id="{{ $promotionGroup['id'] }}" data-promotion_group_action="delete" >
                            Delete
                        </button>
                    </td>
                    <td class="promotionGroupDetails">{{ $promotionGroup['id'] }}</td>
                    <td class="promotionGroupDetails">{{ $promotionGroup['name'] }}</td>
                    <td class="promotionGroupDetails" title="Click for Promotion Details.">{{ $promotionGroup['description'] }}</td>
                    <td class="promotionGroupDetails">{{ ($promotionGroup['status'] == 1) ? 'Active' : 'Inactive' }}</td>
                </tr>
                <tr class="promotionRow" data-promotion_group_id="{{ $promotionGroup['id'] }}">
                    <td colspan="10">
                        <div class="negative-margin" style="margin: -10px;">
                            <table class="table">
                                @if (count($promotionGroup['promotions']) > 0 )
                                    <tr class="promotionDetailsHeader">
                                        <th style="width:20px;">&nbsp;</th>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Status</th>
                                    </tr>
                                    @foreach($promotionGroup['promotions'] as $promotion)
                                        <tr class="promotionDetails">
                                            <td style="width:20px;">&nbsp;</td>
                                            <td>{{ $promotion['id'] }}</td>
                                            <td>{{ $promotion['name'] }}</td>
                                            <td>{{ $promotion['start_date'] }}</td>
                                            <td>{{ $promotion['start_date'] }}</td>
                                            <td>{{ $promotion['status'] }}</td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr class="promotionDetails">
                                        <td colspan="10" align="center"><h2>No Promotions Assigned.</h2></td>
                                    </tr>
                                @endif
                            </table>
                        </div>
                    </td>
                </tr>

            @endforeach <!-- promotionGroups -->
        @else
            <tr>
                <td colspan="10"><h2>No Promotion Groups Defined.</h2></td>
            </tr>
        @endif
        </tbody>
    </table>

    <!-- Modal -->
    <div class="modal " id="promotionGroupEditDialog" tabindex="-1" role="dialog" aria-labelledby="promotionGroupEditLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title" id="promotionGroupEditLabel">Maintain Promotion Group</h4>
                </div>
                <div class="modal-body">
                    <form>
                        {{ csrf_field() }}
                        <input type="hidden" id="promotionGroupId" value="">
                        <input type="hidden" id="promotionGroupAction" value="">

                        <div class="form-group">
                            <label for="promotionGroupName">Name</label>
                            <input class="form-control" id="promotionGroupName" placeholder="Enter Promotion Group Name">
                        </div>
                        <div class="form-group">
                            <label for="promotionGroupDescription">Description</label>
                            <textarea class="form-control" id="promotionGroupDescription" rows="3"></textarea>
                        </div>

                        <div class="form-check">
                            <label class="form-check-label">
                                <input type="checkbox" class="form-check-input" id="promotionGroupStatus" value="1">
                                Active
                            </label>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="promotionGroupSave">Save</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
    @parent
    <script>
        $(document).ready(function(){
            function clearPromotionGroupDialog() {
                $('#promotionGroupName').val('');
                $('#promotionGroupDescription').val('');
                $('#promotionGroupStatus').prop('checked', true);
            }

            function populatePromotionGroupDialog(promotionGroupId) {
                $.ajax({
                    type: 'GET',
                    url: '/offer/api/promotiongroup/get/' + promotionGroupId,
                    dataType: 'json',
                    success: function(result){
                        var promotionGroup = result.data;
                        $('#promotionGroupName').val(promotionGroup.name);
                        $('#promotionGroupDescription').val(promotionGroup.description);
                        if (promotionGroup.status == 1) {
                            $('#promotionGroupStatus').prop('checked', true);
                        } else {
                            $('#promotionGroupStatus').prop('checked', false);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert('Unable to get Promotion Group for id = ' + promotionGroupId + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            function savePromotionGroup() {
                var promotionGroupId = $('#promotionGroupId').val();
                var data = {};
                data._token = $('[name=_token]').val();
                data.id = $('#promotionGroupId').val();
                data.name = $('#promotionGroupName').val();
                data.description = $('#promotionGroupDescription').val();
                data.status = ($('#promotionGroupStatus').prop('checked')) ? 1 : 0;

                $.ajax({
                    type: 'POST',
                    url: '/offer/api/promotiongroup/store',
                    data: data,
                    dataType: 'json',
                    success: function(result){
                        var promotionGroup = result.data;
                        $("#promotionGroupEditDialog").modal('hide');
                        location.reload();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert('Unable to Update Promotion Group id = ' + promotionGroupId + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            function deletePromotionGroup() {
                var data = {};
                data._token = $('[name=_token]').val();
                data.id = $('#promotionGroupId').val();

                $.ajax({
                    type: 'POST',
                    url: '/offer/api/promotiongroup/delete',
                    data: data,
                    dataType: 'json',
                    success: function(result){
                        var promotiongroup = result.data;
                        $("#promotiongroupEditDialog").modal('hide');
                        location.reload();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert('Unable to Delete Promotion Group id = ' + promotiongroupId + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            $('#promotionGroupEditDialog').on('show.bs.modal', function (event) {
                // Button that triggered the modal
                var button = $(event.relatedTarget);
                // Extract action from data-* attributes
                var action = button.data('promotion_group_action');
                var promotionGroupId = button.data('promotion_group_id');

                $('#promotionGroupId').val(promotionGroupId);
                $('.modal-header').removeClass('bg-info');
                $('.modal-header').removeClass('bg-success');
                $('.modal-header').removeClass('bg-danger');

                if (action == 'delete') {
                    $('#promotionGroupEditLabel').html('Delete Promotion Group');
                    $('#promotionGroupAction').val('delete');
                    $('#promotionGroupSave').html('Delete');
                    $('.modal-header').addClass('bg-danger');
                    populatePromotionGroupDialog(promotionGroupId);
                }
                else {
                    if (promotionGroupId == 'new') {
                        $('#promotionGroupEditLabel').html('Add New Promotion Group');
                        $('#promotionGroupAction').val('new');
                        $('#promotionGroupSave').html('Create');
                        $('.modal-header').addClass('bg-success');
                        clearPromotionGroupDialog(promotionGroupId);
                    }
                    else {
                        $('#promotionGroupEditLabel').html('Edit Promotion Group');
                        $('#promotionGroupAction').val('update');
                        $('#promotionGroupSave').html('Update');
                        $('.modal-header').addClass('bg-default');
                        populatePromotionGroupDialog(promotionGroupId);
                    }
                }
            });

            $('#promotionGroupSave').click(function (event) {
                var action = $('#promotionGroupAction').val();
                if (action == 'delete') {
                    deletePromotionGroup();
                } else {
                    savePromotionGroup();
                }
            });

            $('.promotionGroupDetails').click(function(event) {
                var promotionGroupId = $(this).parent().attr('data-promotion_group_id');
                $('.promotionRow[data-promotion_group_id=' + promotionGroupId + ']').toggle();
            });
        });
    </script>
@endsection
