<?php
$default = empty($params['default']) ? '' : trim($params['default']);
$old = trim(old($params['name'], $default));
$params['value'] = empty($params['value']) ? $old : $params['value'];
if ($params['sensitive'] === 1) {
    $params['value'] = '';
}
?>
<div class="{{ 'field-type-' . strtolower(str_slug($params['type'])) }} form-group {{ $dynamicFormGroupClass ?? '' }} {{ $params['type'] == 'hidden' ? ' hidden' : '' }}">
    <label class="control-label {{ $dynamicFormLabelClass ?? '' }}" for="{{ $params['name'] }}">
        {{ $params['displayName'] }}@if($params['required']) <em class="field-is-required text-danger">*</em> @endif
    </label>
    <div class="{{ $dynamicFormControlClass ?? '' }}">
        @if ($params['type'] == 'text')
            <input type="text" class="form-control" id="{{ $params['name'] }}" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}" value="{{ $params['value'] }}" @if( $params['required'] ) required @endif>
        @elseif ($params['type'] == 'password')
            <input type="password" class="form-control" id="{{ $params['name'] }}" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}" value="{{ $params['value'] }}" @if( $params['required'] ) required @endif>
        @elseif ($params['type'] == 'textarea')
            <textarea class="form-control" id="{{ $params['name'] }}" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}" @if( $params['required'] ) required @endif>{{ $params['value'] }}</textarea>
        @elseif ($params['type'] == 'readonly')
            <div class="controls readOnlyText" id="{{ $params['name'] }}" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}">
                {{ $params['value'] }}
            </div>
        @elseif ($params['type'] == 'review')
            <div class="controls readOnlyText" id="{{ $params['name'] }}" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}">
                {{ $params['value'] }}
            </div>
        @elseif ($params['type'] == 'hidden')
            @php
                $value = $params['value'];
                if (! empty($params['options']) && is_array($params['options'])) {
                    $value = array_shift($params['options']);
                }
            @endphp
            <input type="hidden" id="{{ $params['name'] }}" name="{{ $params['name'] }}" data-dynamic_table="{{ $params['table'] }}" value="{{ $value }}" />
        @elseif ($params['type'] == 'date')
            <div class="input-group datepicker">
                <input autocomplete="off" type="text" class="form-control" id="{{ $params['name'] }}" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}" value="{{ Format::date($params['value'], 'm/d/Y') }}" @if( $params['required'] ) required @endif>
                <span class="input-group-addon">
                    <span class="fa fa-calendar"></span>
                </span>
            </div>
        @elseif ($params['type'] == 'datetime')
            <div class="input-group datetimepicker">
                <input autocomplete="off" type="text" class="form-control" id="{{ $params['name'] }}" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}" value="{{ Format::date($params['value'], 'm/d/Y H:i:s') }}" @if( $params['required'] ) required @endif>
                <span class="input-group-addon">
                    <span class="fa fa-calendar"></span>
                </span>
            </div>
        @elseif (in_array($params['type'], ['select', 'selecttext']))
            <select class="form-control" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}" id="{{ $params['name'] }}" @if( $params['required'] ) required @endif>
                @if (! (bool) $params['required'])
                    <option value="" @if( $params['value'] === "" )selected="selected"@endif>--- select ---</option>
                @endif
                @foreach((( ! empty($params['options']) ) ? $params['options'] : [])  as $value => $text)
                    @php $text = trim($text); $value = trim($value); @endphp
                    @if ($params['type'] == 'selecttext')
                        <option value="{{ $text }}" label="{{ $text }}"{{ ($text === $params['value']) ? ' selected="selected"' : '' }}>{{ $text }}</option>
                    @else
                        <option value="{{ $value }}" label="{{ $text }}"{{ ($value === $params['value']) ? ' selected="selected"' : '' }}>{{ $text }}</option>
                    @endif
                @endforeach
            </select>
        @elseif (in_array($params['type'], ['multiselect', 'multiselecttext']))
            <select data-allow-clear="true" data-tags="false" data-close-on-select="false" data-placeholder="Please select all that apply" multiple style="display: block; width: 100%;" class="form-control" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}[]" id="{{ $params['name'] }}" @if( $params['required'] ) required @endif>
                @php
                    if (is_string($params['value'])) {
                        $params['value'] = explode(',', $params['value']);
                    }
                @endphp
                @foreach((! empty($params['options']) ? $params['options'] : [])  as $value => $text)
                    @php $text = trim($text); $value = trim($value); @endphp
                    @if ($params['type'] == 'multiselecttext')
                        <option value="{{ $text }}" label="{{ $text }}"{{ in_array($text, $params['value']) ? ' selected="selected"' : '' }}>{{ $text }}</option>
                    @else
                        <option value="{{ $value }}" label="{{ $text }}"{{ in_array($value, $params['value']) ? ' selected="selected"' : '' }}>{{ $text }}</option>
                    @endif
                @endforeach
            </select>
        @elseif ($params['type'] == 'checkbox')
            <input type="checkbox" id="{{ $params['name'] }}" data-dynamic_table="{{ $params['table'] }}" name="{{ $params['name'] }}" @if ($params['value'] == '1') checked @endif value="{{ empty($params['value']) ? 1 : $params['value'] }}" @if( $params['required'] ) required @endif />
        @else
            <p class="error text-danger">Unknown form field type: '{{ $params['type'] }}', skipped...</p>
        @endif
        @if (isset($params['helpText']) && !empty($params['helpText']))
            <p class="help-block">{!! $params['helpText'] !!}</p>
        @endif
    </div>
</div>
