@php
    $participantTypes = (array) $participantTypes;
@endphp
<!-- Modal claimParticipantDialog -->
<div class="modal " id="claimParticipantDialog" tabindex="-1" role="dialog" aria-labelledby="claimParticipantLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h3 class="modal-title" id="claimParticipantLabel">{{ __('Claim::claim.participants.singular') }}</h3>
            </div>
            <div class="modal-body">
                <form id="addClaimParticipantForm">
                    {{ csrf_field() }}
                    <input type="hidden" id="claimId" value="">
                    <input type="hidden" id="claimParticipantAction" value="">
                    <div class="form-group">
                        <label for="claimParticipantEmail">{{ __('Claim::claim.participants.email') }} <em class="field-is-required text-danger">*</em></label>
                        <input type="email" class="form-control" id="claimParticipantEmail" name="claimParticipantEmail" data-name="participant_email" required/>
                    </div>
                    @if (count($participantTypes) <= 1)
                    <input style="display: none;" type="text" id="claimParticipantType" data-name="participant_type" required name="claimParticipantType" value="{{ array_shift($participantTypes) }}">
                    @else
                        <div class="form-group">
                            <label for="claimParticipantType">{{ __('Claim::claim.participants.type') }} <em class="field-is-required text-danger">*</em></label>
                            <select style="display: block; width: 100%;" class="form-control" name="claimParticipantType" id="claimParticipantType" data-name="participant_type" required>
                                <option value="">{{ __('Core::core.select.default') }}</option>
                                @foreach($participantTypes as $value => $name)
                                    <option value="{{ $name }}">{{ $name }}</option>
                                @endforeach
                            </select>
                        </div>
                    @endif
                </form>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('Core::core.buttons.cancel') }}</button>
                <button type="button" class="btn btn-primary hidden" id="claimParticipantSave" data-item_number="">{{ __('Core::core.buttons.save') }}</button>
                <button type="button" class="btn btn-primary hidden" id="claimParticipantAdd">{{ __('Core::core.buttons.add') }}</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal claimParticipantDialog -->
