@extends('Claim::layouts.forms')

@section('page_heading', 'Create New Form')
@section('page_breadcrumb', 'Create New Form')

@section('page_content')
<div class="row">
    <div class="col-md-6 col-md-offset-3">
        <form class="form-horizontal">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"id="formKey">
                        form.[module].[type].[name]
                    </h3>
                </div>
                <div class="box-body">
                    <div class="col-md-8 col-md-offset-2">
                        <div class="form-group">
                            <label for="moduleSelect" class="control-label">Module:</label>
                            <select class="form-control keyPart" id="moduleSelect">
                                <option value="">-- Select --</option>
                                @foreach($modules as $module)
                                    <option value="{{ $module }}">{{ $module }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="formTypeSelect" class="control-label">Form:</label>
                            <select class="form-control keyPart" id="formTypeSelect">
                                <option value="">-- Select --</option>
                                @foreach($formTypes as $formType)
                                    <option value="{{ $formType }}">{{ $formType }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="formName" class="control-label">Form Name:</label>
                            <input type="text" class="form-control keyPart" id="formName" value=""/>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-footer">
                <button type="button" class="btn btn-danger pull-left" id="cancelButton">Cancel</button>
                <button type="button" class="btn btn-primary pull-right" id="createButton">Create</button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
@parent
<script type="text/javascript">

$(document).ready(function(){

    function getFormKey()
    {
        var formKey = 'form.';
        var moduleName = $('#moduleSelect').val();
        var formType = $('#formTypeSelect').val();
        var formName = $('#formName').val().trim();

        formKey += ((moduleName != '') ? moduleName : '[module]') + '.';
        formKey += ((formType != '') ? formType : '[type]') + '.';
        formKey += ((formName != '') ? formName : '[name]');

        return formKey;
    }

    $('#cancelButton').click(function() {
        window.location = "{{ url('/admin/settings/forms') }}";
    });

    $('#createButton').click(function() {
        var moduleName = $('#moduleSelect').val();
        var formType = $('#formTypeSelect').val();
        var formName = $('#formName').val();
        var formKey = getFormKey();

        if ( moduleName == '' ) {
            alert('Please Select the Module the form is in.');
            return false;
        }

        if ( formType == '' ) {
            alert('Please Select the Type of Form being created.');
            return false;
        }

        if ( formName == '' ) {
            var message = "Please Enter Name for the Form being created.\n";
            message += "No spaces, '.', or other punctuation special characters.\n";
            message += "Use '_' for spaces.\n";
            message += "All lower case, ie: claim_entry_form\n";

            alert(message);
            return false;
        }

        window.location = "{{ url('/admin/settings/forms/edit') }}" + '/' + formKey;
    });

    $('.keyPart').change(function() {
        var formKey = getFormKey();

        $('#formKey').html(formKey);
    });

    $('#formName').keyup(function() {
        $('.keyPart').trigger('change');
    });

});

</script>

@endsection
