var newValueItem = {
    'id':'new',
    'participant_type':'',
    'value_type_id':'1',
    'value':''
}

var newOfferItem = {
    'id':'new',
    'promotion_id':'',
    'name':'',
    'description':'',
    'sku':'',
    'offer_group':'',
    'start_date':'',
    'end_date':'',
    'grace_date':'',
    'value_mode_id':'1',
    'value_type_id':'1',
    'value':'',
    'status':'1',
    'values' : []
}

function setDialogMode(mode) {
    $('.modal-header').removeClass('bg-info');
    $('.modal-header').removeClass('bg-success');
    $('.modal-header').removeClass('bg-danger');

    if ( mode == 'add' ) {
        $('#offerEditLabel').html('ADD New Offer');
        $('#offerAction').val('new');
        $('#offerSave').html('Create');
        $('.modal-header').addClass('bg-success');
    }
    else if ( mode == 'delete' ) {
        $('#offerEditLabel').html('DELETE Offer');
        $('#offerAction').val('delete');
        $('#offerSave').html('Delete');
        $('.modal-header').addClass('bg-danger');
    }
    else {
        $('#offerEditLabel').html('EDIT Offer');
        $('#offerAction').val('update');
        $('#offerSave').html('Update');
        $('.modal-header').addClass('bg-default');
    }
}

// -------------------------------------------
// Example Vue Component for datepicker
// Found at: https://stackoverflow.com/questions/39990617/vue-2-datepicker-component
// -------------------------------------------
/*
Vue.component('datepicker', {

  template: '\
    <input class="form-control datepicker"\
          ref="input"\
          v-bind:value="value"\
          v-on:input="updateValue($event.target.value)"\
          data-date-format="dd-mm-yyyy"\
          data-date-end-date="0d"\
          placeholder="dd-mm-yyyy"\
          type="text"  />\
  ',
  props: {
      value: {
        type: String,
        default: moment().format('DD-MM-YYYY')
      }
  },

  mounted: function() {
    var self = this;
    this.$nextTick(function() {
        $(this.$el).datepicker({
            // startView: 1,
            // todayHighlight: true,
            // todayBtn: "linked",
            format: 'mm/dd/yyyy',
            autoclose: true,
            pickDate: true
        })
        .on('changeDate', function(e) {
            var date = e.format('dd/mm/yyyy');
            self.updateDateValue(date);
        });
    });
  },

  methods : {
    updateDateValue: function (value) {
        this.$emit('input', value);
    },
  }

});
*/

new Vue({

  el: '#offersVue',

  data: {
    valueItems: [],

    formErrors:{},
    formErrorsUpdate:{},

    offerId : 1,
    offer : {},

    editValueIndex : 0,
    editValueItem : {'id':'', 'participant_type':'', 'value_type_id':'', 'value':''}
  },

  mounted() {
      var options = {
          format: 'mm/dd/yyyy',
          autoclose: true,
          pickDate: true
      };

      $('#offerStartDate').datepicker(options).on(
          'changeDate', () => {this.offer.start_date = $('#offerStartDate').val()}
      );

      $('#offerEndDate').datepicker(options).on(
          'changeDate', () => {this.offer.end_date = $('#offerEndDate').val()}
      );

      $('#offerGraceDate').datepicker(options).on(
          'changeDate', () => {this.offer.grace_date = $('#offerGraceDate').val()}
      );
  },

  methods : {

        validateValueRow: function(mode, valueItem)
        {
            var type = $('#valueName').val();
            var value = $('#valueValue').val().trim();

            if ( valueItem.participant_type.trim() == '' ) {
                alert('Please select a Participant Type.');
                return false;
            }

            if ( valueItem.value.trim() === '' || isNaN(value) ) {
                alert('Please enter a Number for Value.');
                return false;
            }

            var typeUsed = false;
            for (var rowIndex in this.offer.values) {
                var tmpValueItem = this.offer.values[rowIndex];
                if ( tmpValueItem.participant_type == valueItem.participant_type ) {
                    if ( mode == 'add' || rowIndex != this.editValueIndex ) {
                        typeUsed = true;
                        break;
                    }
                }
            }

            if ( typeUsed ) {
                alert("Participant Type already in Values list.\nPlease select a different Participant Type.");
                return false;
            }

            return true;
        },

        newValue: function(){
            this.editValueItem = $.extend(true, {}, newValueItem);
            $("#valueSave").addClass('hidden');
            $("#valueAdd").removeClass('hidden');
            $("#valueEditDialog").modal('show');
        },

        addValue: function(){
            if ( ! this.validateValueRow('add', this.editValueItem) )
                return false;

            this.offer.values[this.offer.values.length] = this.editValueItem;
            this.editValueItem = $.extend(true, {}, newValueItem);
            $("#valueEditDialog").modal('hide');
        },

        deleteValue: function(index){
            var valueItems = [];
            count = 0;
            for(ii in this.offer.values) {
                if ( ii == index )
                    continue;
                valueItems[count] = this.offer.values[ii];
                ++count;
            }
            this.offer.values = valueItems;
            // toastr.success('Item Deleted Successfully.', 'Success Alert', {timeOut: 2000});
        },

        editValue: function(valueItem, index){
            this.editValueIndex = index;
            this.editValueItem = $.extend(true, {}, valueItem);

            $("#valueSave").removeClass('hidden');
            $("#valueAdd").addClass('hidden');
            $("#valueEditDialog").modal('show');
        },

        updateValue: function(index){
            if ( ! this.validateValueRow('edit', this.editValueItem) )
                return false;

            this.offer.values[index] = this.editValueItem;
            this.editValueItem = $.extend(true, {}, newValueItem);
            $("#valueEditDialog").modal('hide');
        },

        renderValueType : function(valueTypeId) {
            var valueTypeText = '';

            if ( typeof(valueTypeOptions[valueTypeId]) != 'undefined' )
                valueTypeText = valueTypeOptions[valueTypeId];

            return valueTypeText;
        },

        renderDate : function(dateIn) {
            return ( parseInt(dateIn) > 0 ) ? moment(dateIn).format('M/D/YYYY') : '';
        },

        newOffer: function(){
            this.offer = $.extend(true, {}, newOfferItem);
            this.offer.promotion_id = $('#promotionId').val();
            $('[name="offerValueModeId"][value="' + this.offer.value_mode_id + '"]').trigger('change');

            setDialogMode('add');
            $("#offerEditDialog").modal('show');
        },

        getOffer : function(id) {
            var self = this;
            var offerId = id;

            axios.get('/offer/api/offer/get/' + id)
                .then(function(response) {
                    self.offer = response.data.data;
                    self.offer.start_date = self.renderDate(self.offer.start_date);
                    self.offer.end_date = self.renderDate(self.offer.end_date);
                    self.offer.grace_date = self.renderDate(self.offer.grace_date);
                    $('[name="offerValueModeId"][value="' + self.offer.value_mode_id + '"]').trigger('change');
                })
                .catch(function(response) {
                    var messages = getResponseErrors(response, 'response.data.messages');
                    alert('Unable to Get Offer for Id = ' + offerId + "\n" + messages + response.response.status + ': ' + response.response.statusText);
                });
        },

        editOffer : function(id) {
            this.getOffer(id);
            setDialogMode('edit');
            $("#offerEditDialog").modal('show');
        },

        saveOffer : function() {
            var self = this;
            var token = $('[name=_token]').val();
            var action = $('#offerAction').val();

            var data = $.extend(true, {}, this.offer);
            data._token = token;

            if ( action == 'delete') {
                var id = self.offer.id;
                axios.post('/offer/api/offer/delete', {'offer_id': id, '_token': token})
                    .then(function(response) {
                        self.offer = $.extend(true, {}, newOfferItem);
                        $("#offerEditDialog").modal('hide');
                        location.reload();
                    })
                    .catch(function(response) {
                        var messages = getResponseErrors(response, 'response.data.messages');
                        alert('Unable to Delete Offer for Id = ' + data.id + "\n" + messages + response.response.status + ': ' + response.response.statusText);
                    });
            }

            else {
                axios.post('/offer/api/offer/store', data)
                    .then(function(response) {
                        self.offer = $.extend(true, {}, newOfferItem);
                        $("#offerEditDialog").modal('hide');
                        location.reload();
                    })
                    .catch(function(response) {
                        var messages = getResponseErrors(response, 'response.data.messages');
                        if ( data.id == 'new' )
                            alert('Unable to Create New Offer' + "\n" + messages + response.response.status + ': ' + response.response.statusText);
                        else
                            alert('Unable to Save Offer for Id = ' + data.id + "\n" + messages + response.response.status + ': ' + response.response.statusText);
                    });
            }
        },

        deleteOffer : function(id) {
            this.getOffer(id);
            setDialogMode('delete');
            $("#offerEditDialog").modal('show');
        }
    }
});
