<?php

namespace Ignite\Claim\Models\Grid;

use Ignite\Claim\Entities\ClaimParticipant;

class ProcessFormatter extends ClaimFormatter
{
    /**
     * Format the actions column.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function actions($model)
    {
        if (! $model) {
            return $this->html('');
        }

        return $this->html(
            $this->button('View', route('admin.claim.quickview', [
                'claim_participant_id' => $model->id,
                'claim_id' => $model->user_id
            ]))
        );
    }

    /**
     * Format the name column.
     *
     * @param  ClaimParticipant $claimParticipant
     * @return \Illuminate\Support\HtmlString
     */
    public function name(ClaimParticipant $claimParticipant)
    {
        if (! $claimParticipant && ! $claimParticipant->participant) {
            return $this->html('');
        }

        return $this->html(
            sprintf(
                '%s %s',
                $claimParticipant->participant->first,
                $claimParticipant->participant->last
            )
        );
    }

    /**
     * Format a checkbox for selecting items in the grid.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        if (! $model) {
            return $this->html('');
        }

        return $this->formatCheckbox($model->id);
    }
}
