<?php

namespace Ignite\Claim\Events\Handlers\Menus;

use Ignite\Core\Entities\Participant;
use Ignite\Core\Events\Menus\ActionMenuPreCompile;
use Ignite\Core\Program;

class AddClaimToParticipantActionMenu
{
    /**
     * @var Program
     */
    private $program;

    /**
     * AddCatalogToParticipantActionMenu constructor.
     *
     * @param Program $program
     */
    public function __construct(Program $program)
    {
        $this->program = $program;
    }

    /**
     * Handle the event.
     *
     * @param ActionMenuPreCompile $event
     */
    public function handle(ActionMenuPreCompile $event)
    {
        $context = $event->getContext();

        if (! isset($context['model']) || $context['model'] !== Participant::class) {
            return;
        }

        if (! isset($context['primaryKey']) || empty($context['model'])) {
            return;
        }
        
        foreach ($this->getItems($event->getContext()) as $item) {
            $event->getManager()->getItems()->first()->addChild(
                $event->getManager()->hydrateItem($item)
            );
        }
    }

    /**
     * Get the items to merge with the menu.
     *
     * @param  array $context
     * @return \Illuminate\Support\Collection
     */
    protected function getItems(array $context)
    {
        return collect([
            [
                'position' => 30,
                'url' => route('admin.participant.claims', [$context['primaryKey']]),
                'label' => 'View Claims',
                'icon' => 'gift',
                'allow' => auth()->user()->can('core.user.participant.claims.browse')
            ],
        ]);
    }
}
