@php

if ($params['sensitive'] === 1 && ! empty($params['value'])) {
    $mask = $params['tableFormat'] ?: '*****';
    try {
        $value = decrypt($params['value']);
        if (auth()->user()->hasGroup(['admin'])) {
            $params['displayName'] .= ' (Showing sensitive data to privileged user)';
        } else {
            $value = substr_replace($value, $mask, 0, 5);
        }
        $params['value'] = $value;
    } catch (\Exception $e) {
        $value = $params['value'];
        if (auth()->user()->hasGroup(['admin'])) {
            $params['value'] = 'Error decrypting value: ' . $e->getMessage();
        } else {
            $params['value'] = substr_replace($value, $mask, 0, 5);
        }
    }
}

@endphp

@if (in_array($params['type'], ['review', 'text']))
    <div class="dynamicDisplayText form-field-text form-group {{ $dynamicFormGroupClass ?? '' }}">
        <label class="control-label {{ $dynamicFormLabelClass ?? '' }}" for="{{ $params['name'] }}">{{ $params['displayName'] }}</label>
        <div class="displayOnly controls bg-white {{ $dynamicFormControlClass ?? '' }}" id="{{ $params['name'] }}" name="{{ $params['name'] }}">
            <input class="form-control" readonly value="{{ $params['value'] }}"/>
        </div>
    </div>

@elseif ($params['type'] == 'password')
    <div class="dynamicDisplayReadonly form-field-password form-group {{ $dynamicFormGroupClass ?? '' }}">
        <label class="control-label {{ $dynamicFormLabelClass ?? '' }}" for="{{ $params['name'] }}">{{ $params['displayName'] }}</label>
        <div class="displayOnly controls {{ $dynamicFormControlClass ?? '' }}" id="{{ $params['name'] }}" name="{{ $params['name'] }}">
            <input type="password" class="form-control" readonly value="{{ str_repeat('x', strlen($params['value'])) }}"/>
        </div>
    </div>

@elseif ($params['type'] == 'readonly')
    <div class="dynamicDisplayReadonly form-field-readonly form-group {{ $dynamicFormGroupClass ?? '' }}">
        <label class="control-label {{ $dynamicFormLabelClass ?? '' }}" for="{{ $params['name'] }}">{{ $params['displayName'] }}</label>
        <div class="displayOnly controls {{ $dynamicFormControlClass ?? '' }}" id="{{ $params['name'] }}" name="{{ $params['name'] }}">
            <input class="form-control" readonly value="{{ $params['value'] }}"/>
        </div>
    </div>

@elseif ($params['type'] == 'textarea')
    <div class="dynamicDisplayTextarea form-field-textarea form-group {{ $dynamicFormGroupClass ?? '' }}">
        <label class="control-label {{ $dynamicFormLabelClass ?? '' }}" for="{{ $params['name'] }}">{{ $params['displayName'] }}</label>
        <div class="displayOnly controls {{ $dynamicFormControlClass ?? '' }}" id="{{ $params['name'] }}" name="{{ $params['name'] }}">
            <textarea readonly class="form-control {{ $dynamicFormControlClass ?? '' }}" id="{{ $params['name'] }}" name="{{ $params['name'] }}" disabled @if( $params['required'] ) required @endif>{{ $params['value'] }}</textarea>
        </div>
    </div>

@elseif ($params['type'] == 'date')
    <div class="dynamicDisplayDate form-field-date form-group {{ $dynamicFormGroupClass ?? '' }}">
        <label class="control-label {{ $dynamicFormLabelClass ?? '' }}" for="{{ $params['name'] }}">{{ $params['displayName'] }}</label>
        <div class="displayOnly controls bg-white {{ $dynamicFormControlClass ?? '' }}" id="{{ $params['name'] }}" name="{{ $params['name'] }}">
            <input class="form-control" readonly value="{{ Format::date($params['value']) }}"/>
        </div>
    </div>

@elseif ($params['type'] == 'datetime')
    <div class="dynamicDisplayDate form-field-datetime form-group {{ $dynamicFormGroupClass ?? '' }}">
        <label class="control-label {{ $dynamicFormLabelClass ?? '' }}" for="{{ $params['name'] }}">{{ $params['displayName'] }}</label>
        <div class="displayOnly controls bg-white {{ $dynamicFormControlClass ?? '' }}" id="{{ $params['name'] }}" name="{{ $params['name'] }}">
            <input class="form-control" readonly value="{{ Format::datetime($params['value']) }}"/>
        </div>
    </div>

@elseif (in_array($params['type'], ['select', 'selecttext', 'multiselect', 'multiselecttext']))
    <div class="{{ 'dynamicDisplay' . ucwords($params['type']) }} form-field-select form-group {{ $dynamicFormGroupClass ?? '' }}">
        <label class="control-label {{ $dynamicFormLabelClass ?? '' }}" for="{{ $params['name'] }}">{{ $params['displayName'] }}</label>
        <div class="displayOnly controls bg-white {{ $dynamicFormControlClass ?? '' }}" id="{{ $params['name'] }}" name="{{ $params['name'] }}">
            @if (in_array($params['type'], ['selecttext', 'multiselect', 'multiselecttext']))
                @if (is_array($params['value']))
                    @php $params['value'] = implode(',', $params['value']); @endphp
                @endif
                <input class="form-control" readonly value="{{ $params['value'] }}"/>
            @else
                <input class="form-control" readonly value="{{ (( ! empty($params['options'][$params['value']]) ) ? $params['options'][$params['value']] : '') }}"/>
            @endif
        </div>
    </div>

@elseif ($params['type'] == 'checkbox')

    <div class="dynamicDisplayReadonly form-field-checkbox form-group {{ $dynamicFormGroupClass ?? '' }}">
        <label class="control-label {{ $dynamicFormLabelClass ?? '' }}" for="{{ $params['name'] }}">{{ $params['displayName'] }}</label>
        <div class="displayOnly controls {{ $dynamicFormControlClass ?? '' }}" id="{{ $params['name'] }}" name="{{ $params['name'] }}">
            <input type="text" class="form-control" readonly value="{{ $params['value'] == '1' ? 'Yes' : 'No' }}"/>
        </div>
    </div>

@elseif ($params['type'] == 'hidden')

@else
    <div class="form-group {{ $dynamicFormGroupClass ?? '' }}">
        <h3>Unknown Form Field type = '{{ $params['type'] }}', skipped...</h3>
    </div>

@endif
