<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Entities\Form;
use Ignite\Claim\Entities\Setting;
use Ignite\Claim\Traits\ValidatesFields;

class RuleCondition extends Model
{
	use ValidatesFields;

	/**
	 * The table name.
	 * @var string
	 */
    protected $table = 'claim_rule_condition';

	/**
	 * The primary key.
	 * @var string
	 */
    protected $primaryKey = 'id';

	/**
	 * The field type declarations.
	 * @var array
	 */
    public static $fields = [
        'id'                    => [ 'type' => 'integer'],
        'rule_id'               => [ 'type' => 'integer'],
        'db_column'             => [ 'type' => 'string'],
        'directive'             => [ 'type' => 'string',            'default' => '='],
        'data_1'                => [ 'type' => 'string'],
        'data_2'                => [ 'type' => 'string',            'default' => null],
        'order'                 => [ 'type' => 'integer',           'default' => '0'],
    ];

	/**
	 * The directive defintions.
	 * @var array
	 */
    public static $directives = [
        '='             => 'Equals',
        '!='            => 'Not Equal To',
        '>'             => 'Greater Than',
        '<'             => 'Less Than',
        '>='            => 'Greater Than Or Equal To',
        '<='            => 'Less Than Or Equal To',
        'BETWEEN'       => 'Between',
        'IN'            => 'In List',
        'NOT IN'        => 'Not In List',
        'LIKE'          => 'Is Like',
	];

	/**
	 * The database column definitions.
	 * @var array
	 */
    public static $dbColumns = [
        'participant|country'  => ['type' => 'string', 'name' => 'Participant - Country'],
        'participant|region'   => ['type' => 'string', 'name' => 'Participant - Region'],
        'participant|state'    => ['type' => 'string', 'name' => 'Participant - State'],
        'participant|city'     => ['type' => 'string', 'name' => 'Participant - City'],
        'claim|activity_date'  => ['type' => 'date',   'name' => 'Claim - Date'],
        'claim|type'           => ['type' => 'string', 'name' => 'Claim - Type'],
        'claim|customer_city'  => ['type' => 'string', 'name' => 'Claim - Customer City'],
        'claim|customer_state' => ['type' => 'string', 'name' => 'Claim - Customer State'],
        'claim|sale_value'     => ['type' => 'number', 'name' => 'Claim - Sale Value'],
	];

	/**
	 * The relationship to the Rule model.
	 *
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
    public function rule()
    {
        return $this->belongsTo('Ignite\Claim\Entities\Rule', 'rule_id');
    }

    public static function getComparableColumns()
    {
        $columns = [];

        // Claim Participant Columns
        $columns['participant|participant_type'] = ['type' => 'string', 'name' => 'Participant - Type'];
        $columns['participant|participant_email'] = ['type' => 'string', 'name' => 'Participant - Email'];

        // Claim Columns
        $claimSetting = Form::findByKey('form.claim.partial.claim_fields_external');
        $claimColumns = $claimSetting->columns['claim'];

        foreach ($claimColumns as $column) {
            $columns[$column['table'] . '|' . $column['name']] = [
                'type' => $column['type'],
                'name' => 'Claim - ' . $column['displayName']
            ];
        }

        return $columns;
    }
}
