<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Catalog\Entities\Catalog;
use Ignite\Catalog\Entities\Vendor;

class CatalogTableSeeder extends AbstractCatalogSeeder
{
    /**
     * The name of the data file.
     *
     * @var string
     */
    protected $file = 'catalog.json';

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath($this->file)
        ]);

        $catalogs = $strategy->run();

        foreach ($catalogs as $catalog) {
            try {
                $vendor = Vendor::query()->where('name', $catalog['vendor_name'])->first();
                $catalog['catalog_vendor_id'] = $vendor->getKey();
                unset($catalog['vendor_name']);

                Catalog::query()->updateOrCreate([
                    // code is set based off name in Ignite\Catalog\Entities\Catalog
                    'name' => $catalog['name'],
                ], $catalog);
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
