<?php

namespace Ignite\Catalog\Contracts;

use Illuminate\Support\Collection;

interface VendorRepository
{
    /**
     * The default vendor query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * Find all active vendors.
     *
     * @return Collection
     */
    public function findActive();

    /**
     * Find all vendors.
     *
     * @return Collection
     */
    public function findAll();

    /**
     * Find a vendor.
     *
     * @param  int $id
     * @return \Ignite\Catalog\Entities\Vendor
     */
    public function find($id);

    /**
     * Create a vendor.
     *
     * @param  Collection $data
     * @return \Ignite\Catalog\Entities\Vendor
     */
    public function create(Collection $data);

    /**
     * Update a vendor.
     *
     * @param  int $id
     * @param  Collection $data
     * @return \Ignite\Catalog\Entities\Vendor
     */
    public function update($id, Collection $data);

    /**
     * Delete the records with the given IDs.
     *
     * @param  int $id
     * @return \Ignite\Catalog\Entities\Vendor
     */
    public function delete($id);

    /**
     * Delete many vendors and associated data.
     *
     * @param  array $ids
     * @return bool
     */
    public function deleteMany(array $ids);
}
