<?php

namespace Ignite\Catalog\Tests\Unit\Models;

use Illuminate\Support\HtmlString;
use Ignite\Catalog\Models\Grid\AttributeFormatter;
use Ignite\Catalog\Tests\TestCase;

class CatalogFormatterTest extends TestCase
{
    public function setUp() : void
    {
        parent::setUp();
    }

    /**
     * @test
     * @group Catalog
     * @group Grid
     * @group Attribute
     * @group Formatter
     */
    public function it_can_format_a_checkbox()
    {
        $formatter = new AttributeFormatter();

        $model = new \Ignite\Catalog\Entities\Attribute();
        $model->id = 1;

        /** @var \Illuminate\Support\HtmlString $html */
        $html = $formatter->checkbox($model);

        $this->assertInstanceOf(HtmlString::class, $html);
        $this->assertSame('<input type="checkbox" class="dt-checkboxes" name="entries[]" value="1" />', $html->toHtml());
    }

    /**
     * @test
     * @group Catalog
     * @group Grid
     * @group Attribute
     * @group Formatter
     */
    public function it_can_format_the_actions_for_a_row()
    {
        $this->loadRoutes(['catalog']);

        $formatter = new AttributeFormatter();

        $model = new \Ignite\Catalog\Entities\Attribute();
        $model->id = 1;

        $expected = '<div class="btn-group"><a href="http://localhost/admin/catalog/attributes/1/edit" class="btn btn-sm btn-default btn-edit"><span class="text-default"><i class="fa-solid fa-pencil"></i> Edit</span></a><button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="caret"></span></button><ul class="dropdown-menu"><li><a href="http://localhost/admin/catalog/attributes/1" class="default view"><span class="text-default"><i class="fa-solid fa-eye"></i> View</span></a></li></ul></div>';


        /** @var \Illuminate\Support\HtmlString $html */
        $html = $formatter->actions($model);

        $this->assertInstanceOf(HtmlString::class, $html);
        $this->assertSame($expected, $html->toHtml());
    }

    /**
     * @test
     * @group Catalog
     * @group Grid
     * @group Attribute
     * @group Formatter
     */
    public function it_can_format_the_use_in_filter_value_as_yes()
    {
        $formatter = new AttributeFormatter();

        $model = new \Ignite\Catalog\Entities\Attribute();
        $model->use_in_filter = '1';

        /** @var \Illuminate\Support\HtmlString $html */
        $html = $formatter->useInFilter($model);

        $this->assertInstanceOf(HtmlString::class, $html);
        $this->assertSame('Yes', $html->toHtml());
    }

    /**
     * @test
     * @group Catalog
     * @group Grid
     * @group Attribute
     * @group Formatter
     */
    public function it_can_format_the_use_in_filter_value_as_no()
    {
        $formatter = new AttributeFormatter();

        $model = new \Ignite\Catalog\Entities\Attribute();
        $model->use_in_filter = '0';

        /** @var \Illuminate\Support\HtmlString $html */
        $html = $formatter->useInFilter($model);

        $this->assertInstanceOf(HtmlString::class, $html);
        $this->assertSame('No', $html->toHtml());
    }

    /**
     * @test
     * @group Catalog
     * @group Grid
     * @group Attribute
     * @group Formatter
     */
    public function it_can_format_the_use_in_filter_value_as_no_when_the_model_null()
    {
        $formatter = new AttributeFormatter();

        /** @var \Illuminate\Support\HtmlString $html */
        $html = $formatter->useInFilter(null);

        $this->assertInstanceOf(HtmlString::class, $html);
        $this->assertSame('No', $html->toHtml());
    }
}
