@extends('Catalog::layouts.master')

@section('page_heading', "Order {$order->present()->getNumber()}")

@section('page_breadcrumb', "Order {$order->present()->getNumber()}")

@section('page_content')

    @if ($order->isProcessing())
    @include('Catalog::admin._partials.orders.items.attempts')
    @endif

    <div class="form-horizontal">
        <div class="row form-affix-container">
            <div class="col-sm-4">
                @if ($order->isCancelable() && $order->isProcessable())
                <div class="box box-solid form-affix">
                    <div class="box-body no-padding">
                        <div class="btn-group btn-group-justified">
                            @if ($order->isProcessable())
                            <a class="btn btn-default" onclick="{{ trans('Catalog::order.misc.status.processed.confirm') }}" href="{{ $order->present()->getAdminProcessUrl() }}">
                                <i class="fa-solid fa-check text-green"></i>
                                <span class="text-green">{{ trans('Catalog::order.misc.status.processed.action') }}</span>
                            </a>
                            @endif
                            @if ($order->isCancelable())
                            <a class="btn btn-default" onclick="{{ trans('Catalog::order.misc.status.cancelled.confirm') }}" href="{{ $order->present()->getAdminCancelUrl() }}">
                                <i class="fa-solid fa-ban text-red"></i>
                                <span class="text-red">{{ trans('Catalog::order.misc.status.cancelled.action') }}</span>
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                @component('Core::admin.components.menu-buttons')
                    @component('Core::admin.components.menu-button')
                        @slot('link', $referer)
                        @slot('icon', 'fa-solid fa-chevron-left')
                        <span>{{ trans('Core::core.buttons.back') }}</span>
                    @endcomponent
                @endcomponent
                @endif

                {!! form_start($form) !!}
                @component('Core::admin.components.box', ['classes' => 'order-form'])
                    @slot('title')
                        <h2 class="box-title">{{ trans('Catalog::order.misc.show.details.heading') }} &mdash; {{ trans('Catalog::order.fields.id.label') }}: {{ $order->getKey() }}</h2>
                        <a class="pull-right" href="{{ route('admin.participant.show', $order->present()->getParticipantId()) }}">{{ trans('Catalog::order.misc.participant.view') }}</a>
                    @endslot
                    @slot('footer')
                        {!! form_row($form->submit) !!}
                    @endslot
                    {!! form_rest($form) !!}
                @endcomponent
                {!! form_end($form) !!}
            </div>
            <div class="col-sm-8 form-affix-body">
            @component('Core::admin.components.box')
                @if ($order->isProcessed())
                    <div style="margin: -10px -10px 10px;border-radius: 0;border-left: 0;border-right: 0;" class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <div class="no-padding no-margin">
                            <span class="fa-solid fa-info-circle icon"></span>
                            {{ trans('Catalog::order.misc.status.processed.state') }}
                        </div>
                    </div>
                @elseif ($order->isCancelled())
                    <div style="margin: -10px -10px 10px;border-radius: 0;border-left: 0;border-right: 0;" class="alert alert-danger alert-dismissible bg-red-gradient">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <h5 class="no-padding no-margin">
                            <span class="fa-solid fa-info-circle icon"></span>
                            {{ trans('Catalog::order.misc.status.cancelled.state') }}
                        </h5>
                    </div>
                @else
                    <div style="margin: -10px -10px 10px;border-radius: 0;border-left: 0;border-right: 0;" class="alert alert-warning alert-dismissible bg-orange-gradient">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <h5 class="no-padding no-margin">
                            <span class="fa-solid fa-info-circle icon"></span>
                            {{ trans('Catalog::order.misc.status.processing.state') }}
                        </h5>
                    </div>
                @endif
                @slot('title', trans('Catalog::order.misc.show.items.heading'))
                {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
            @endcomponent
            </div>
        </div>
    </div>

    <div id="order-item-vendor-inspect" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content"></div>
        </div>
    </div>
    <div id="order-item-vendor-mark-processed" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content"></div>
        </div>
    </div>
    <div id="order-item-vendor-mark-cancelled" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content"></div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        var openDynamicModel = function(action, target) {
            $(target).find('.modal-content').html('<div class="modal-body text-center"><p><span class="fa-solid fa-refresh fa-spin fa-3x fa-fw"></span><br />{{ trans('Core::core.common.loading') }}...</p></div>');
            $(target).on('hidden.bs.modal', function() {
                action.data('bs.modal', null);
                $(this).removeData('bs.modal');
            }).modal({
                'remote': action.attr('href')
            });
        };
        $(document).ready(function() {
            var table = $('#dataTableBuilder').DataTable();
            table.on('draw', function () {
                $('[data-toggle="tooltip"]').tooltip();
            });

            $(document).on('click', '.open-item-inspector', function(evt) {
                evt.preventDefault();
                openDynamicModel($(this), '#order-item-vendor-inspect')
            });

            $(document).on('click', '.mark-processed', function(evt) {
                evt.preventDefault();
                openDynamicModel($(this), '#order-item-vendor-mark-processed');
            });

            $(document).on('click', '.mark-cancelled', function(evt) {
                evt.preventDefault();
                openDynamicModel($(this), '#order-item-vendor-mark-cancelled');
            });
        });
    </script>
@endsection
