@extends('Catalog::layouts.master')

@section('page_heading', "Viewing Menu: {$menu->name}")
@section('page_breadcrumb', "Viewing Menu: {$menu->name}")

@section('css')
    @parent
    <link rel="stylesheet" href="{{ asset('/vendor/ignite/js/vendor/jqtree/jqtree.css') }}" />
@endsection

@section('page_content')
    <div class="row">
        <div class="col-sm-3">
            @component('Core::admin.components.menu-buttons')
                @component('Core::admin.components.menu-button')
                    @slot('link', route('admin.catalog.menus.index'))
                    @slot('icon', 'fa-solid fa-chevron-left')
                    <span>{{ trans('Core::core.buttons.back') }}</span>
                @endcomponent
                @component('Core::admin.components.menu-button', ['classes' => 'delete-entry'])
                    @slot('link', route('admin.catalog.menus.destroy', $menu))
                    @slot('icon', 'fa-trash text-danger')
                    <span class="text-danger">{{ trans('Core::core.buttons.delete') }}</span>
                @endcomponent
                @component('Core::admin.components.menu-button')
                    @slot('link', route('admin.catalog.menus.edit', $menu))
                    @slot('icon', 'fa-pencil')
                    <span>{{ trans('Core::core.buttons.edit') }}</span>
                @endcomponent
            @endcomponent
        </div>
        <div class="col-sm-9">
            @component('Core::admin.components.box')
                @slot('title')
                    {{ ucwords($menu->name) }}
                @endslot
                @component('Core::admin.components.data-list')
                    @foreach ($menu->toPresentableArray() as $key => $value)
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', str_replace('_', ' ', title_case($key)))
                            {!! $value !!}
                        @endcomponent
                    @endforeach
                @endcomponent
                <hr />
                <div id="menu-tree"></div>
           @endcomponent
       </div>
   </div>
@endsection

@section('js')
    @parent
    <script src="{{ asset('/vendor/ignite/js/vendor/jqtree/tree.jquery.js') }}"></script>
    <script src="{{ asset('/vendor/ignite/js/catalog/menus.js') }}"></script>
    <script type="text/javascript">
      $(document).ready(function() {
        $('#menu-tree').menuManager({
          token: "{{ csrf_token() }}",
          menuId: {{ $menu->getKey() }},
          itemsField: null,
          options: {
            dragAndDrop: false,
            selectable: false
          },
          loadUrl: "{{ route('api.catalog.menus.items', $menu) }}",
        });

        $.deleteEntry({
          confirmation: 'Are you sure you want to delete this menu?',
          request: { method: 'DELETE', type: 'json' },
          data: function (button) {
            return {
              _token: "{{ csrf_token() }}",
              id: button.attr('href').split('/').pop()
            }
          },
          onSuccess: function(button, result) {
            if (result.status === 'success') {
              setTimeout(function () {
                window.location.href = "{{ route('admin.catalog.menus.index') }}";
              }, 1000);
            }
          }
        });
      });
    </script>
@endsection
