@extends('Catalog::layouts.master')

@section('page_breadcrumb', trans('Catalog::catalog.misc.show.heading', ['name' => $catalog->name]))
@section('page_heading', trans('Catalog::catalog.misc.show.heading', ['name' => $catalog->name]))

@section('page_content')
    <div class="row">
        <div class="col-sm-3">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">{{ $catalog->name }} <small>/{{ $catalog->code }}</small></h3>
                </div>
                <div class="box-body">
                    @foreach ($catalog->toPresentableArray() as $key => $value)
                        <dl class="dl-horizontal ig-list-horizontal">
                            <dt class="ig-list-horizontal-label" style="text-align: left; width: 120px;">{{ str_replace('_', ' ', title_case($key)) }}</dt>
                            <dd style="margin-left: 120px;">{!! $value !!}</dd>
                        </dl>
                    @endforeach
                </div>
            </div>
            <div class="box box-solid">
                <div class="box-body no-padding">
                    <ul class="nav nav-pills nav-stacked">
                        <li>
                            <a href="{{ route('admin.catalog.index') }}">
                                <span class="fa-solid fa-chevron-left"></span>
                                <span>{{ trans('Core::core.buttons.back') }}</span>
                            </a>
                            <a href="{{ route('admin.catalog.destroy', $catalog) }}" class="delete-entry">
                                <span class="fa-solid fa-trash text-danger"></span>
                                <span class="text-danger">{{ trans('Core::core.buttons.delete') }}</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-sm-9">
            <div class="box box-primary">
                <div class="box-body">
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var table = $('#dataTableBuilder').DataTable();
            table.on('draw', function () {
                $('[data-toggle="tooltip"]').tooltip();
            });

            $.deleteEntry({
                confirmation: "{{ trans('Catalog::catalog.delete.confirm') }}",
                request: { method: 'DELETE', type: 'json' },
                data: function (button) {
                    return {
                        _token: "{{ csrf_token() }}",
                        id: button.attr('href').split('/').pop()
                    }
                },
                onSuccess: function(button, result) {
                    if (result.status === 'success') {
                      setTimeout(function () {
                        window.location.href = "{{ route('admin.catalog.index') }}";
                      }, 1000);
                    }
                }
            });
        });
    </script>
@endsection
