<div class="alert alert-danger alert-dismissible bg-red-gradient">
    @if ($closable ?? true)
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
    @endif
    <p>
        <span class="fa-solid fa-exclamation-triangle"></span>
        Error processing {{ isset($item) ? optional($item)->name . ' ' : '' }}Request ID: {{ $requestId }}
        <button data-toggle="collapse" role="button" class="btn btn-danger btn-xs pull-right" href="#errors-{{ $index }}" aria-expanded="false" aria-controls="errors-{{ $index }}">
            {{ $buttonLabel ?? 'View Errors' }}
        </button>
    </p>
    <ul class="list-unstyled collapse" id="errors-{{ $index }}">
        @foreach ($errors as $key => $error)
            @php $error = (array) $error; @endphp
            <li>
                @if (is_numeric(array_keys($error)[0]))
                    @if (! is_numeric($error[0]))
                        @if (starts_with($error[0], '#'))
                            <pre>{{ $error[0] }}</pre>
                        @else
                            {{ $error[0] }}
                        @endif
                    @endif
                @else
                    @if (array_key_exists('errorCode', $error))
                        <code class="label label-danger">{{ $error['errorCode'] }}</code>
                    @endif
                    @if (array_key_exists('message', $error))
                        {{ $error['message'] }}
                    @endif
                @endif
            </li>
        @endforeach
    </ul>
</div>
