<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Ignite\Catalog\Entities\Category;
use Ignite\Core\Models\Grid\EloquentTable;
use Yajra\DataTables\DataTables;

class CategoriesTable extends EloquentTable
{
    /**
     * @var CategoryFormatter
     */
    protected $formatter;

    /**
     * The forms to look up for extra columns.
     * @var array
     */
    protected $forms = [];

    /**
     * The excluded column keys.
     * @var array
     */
    protected $excludedKeys = [];

    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [];

    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        CategoryFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'checkbox' => [
                'defaultContent' => '',
                'title'          => '',
                'data'           => 'checkbox',
                'name'           => 'checkbox',
                'orderable'      => false,
                'searchable'     => false,
                'exportable'     => false,
                'printable'      => false,
                'width'          => '10px',
            ],
            'action' => [
                'name' => 'actions',
                'title' => trans('Core::core.common.actions'),
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '80px',
                'class' => 'actions'
            ],
            'id' => [
                'title' => trans('Catalog::category.fields.id.label'),
                'name' => 'catalog_category.id',
                'orderable' => true,
                'exportable' => true,
            ],
            'name' => [
                'title' => trans('Catalog::category.fields.name.label'),
                'name' => 'catalog_category.label',
                'orderable' => true,
                'exportable' => true,
            ],
            'image' => [
                'title' => trans('Catalog::category.fields.image.label'),
                'name' => 'catalog_category.code',
                'orderable' => true,
                'exportable' => true,
            ],
            'icon' => [
                'title' => trans('Catalog::category.fields.icon.label'),
                'name' => 'catalog_category.type',
                'orderable' => true,
                'exportable' => true,
            ],
            'active' => [
                'title' => trans('Catalog::category.fields.active.label'),
                'name' => 'catalog_category.active',
                'orderable' => true,
                'exportable' => true,
            ],
            'created_at' => [
                'title' => trans('Catalog::category.fields.created_at.label'),
                'name' => 'catalog_category.created_at',
                'orderable' => true,
                'exportable' => true,
                'visible' => true,
            ],
        ];
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        return Category::query();
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'checkbox' => [$this->formatter, 'checkbox'],
            'action' => [$this->formatter, 'actions'],
            'image' => [$this->formatter, 'image'],
            'icon' => [$this->formatter, 'icon'],
            'active' => [$this->formatter, 'active'],
            'created_at' => [$this->formatter, 'createdAt'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            "order" => [2, 'asc'] // ID
        ], $this->getCheckboxColumnParameters());
    }
}
