<?php

namespace Ignite\Catalog\Jobs\Tango;

use Ignite\Catalog\Events\CompleteTangoOrder;
use Ignite\Catalog\Jobs\ProcessManager as BaseProcessManager;
use Ignite\Vendor\Tango\Response\OrderResponse;
use InvalidArgumentException;

class ProcessManager extends BaseProcessManager
{
    /**
     * Complete the order.
     *
     * @param OrderResponse $response
     * @param array $meta
     *
     * @return bool
     */
    public function complete($response, array $meta = [])
    {
        parent::complete($response, $meta);
        CompleteTangoOrder::dispatch($this->order, $this->orderItem, $response, $this->requestId);

        return true;
    }

    /**
     * Gets the order number from the response.
     *
     * @param  array  $meta
     * @return null|string
     */
    protected function getResponseOrderNumber(array $meta)
    {
        if (empty($meta['attempts'])) {
            return null;
        }

        $attempts = array_reverse($meta['attempts']);

        foreach ($attempts as $attempt) {
            if (empty($attempt['response']['referenceOrderID'])) {
                continue;
            }
            return $attempt['response']['referenceOrderID'];
        }
    }

    /**
     * Determine whether the order response is complete.
     *
     * @param Base $response
     *
     * @return bool
     */
    public function isOrderComplete($response)
    {
        if (!$response instanceof OrderResponse) {
            throw new InvalidArgumentException('Response must be an instance of ' . OrderResponse::class);
        }

        return (!empty($response->getReferenceOrderID()) && 'COMPLETE' === $response->getStatus());
    }
}
