<?php

namespace Ignite\Catalog\Http\Controllers;

use Ignite\Catalog\Entities\Item;
use Ignite\Core\Http\Controllers\Controller;

class ItemController extends Controller
{
    /**
     * Show the item.
     *
     * @param  Item $item
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function show(Item $item)
    {
        /**
         * If item is inactive, redirect them back to the catalog.
         * This is a rare occurence but if a user bookmarks an inactive item or accesses the inactive item
         * directly through the URL, we want to make sure they are redirected back to the catalog.
         */
        if (!$item->active) {
            return redirect()->route('catalog.show', $item->catalog->code);
        }
        
        $item = $item->load('catalog');

        if (! session()->has('catalog') || session('catalog.id') !== $item->catalog->id) {
            session()->put('catalog', $item->catalog->toSessionData());

            return redirect()->route('catalog.show', $item->catalog->code);
        }

        return view('catalog.item.show', compact('item'));
    }
}
