<?php

namespace Ignite\Catalog\Validation\Strategies;

use Ignite\Catalog\Models\Cart;

/**
 * Validation strategy for Hawk vendor
 */
class HawkValidationStrategy extends AbstractValidationStrategy
{
    /**
     * {@inheritdoc}
     */
    public function getValidationRules(Cart $cart = null, array $context = []): array
    {
        $rules = $this->mergeRules(
            $this->getBaseRules(),
             $this->getVendorRules('hawk')
         );

        return $this->filterRulesByCart($rules, $cart);
    }

    /**
     * {@inheritdoc}
     */
    public function getValidationMessages(Cart $cart = null): array
    {
        $messages = $this->mergeMessages(
            $this->getBaseMessages(),
            $this->getVendorMessages('hawk')
        );

        return $this->filterMessagesByCart($messages, $cart);
    }

    /**
     * {@inheritdoc}
     */
    public function supports(string $vendorName): bool
    {
        return strtolower($vendorName) === 'hawk';
    }
} 
