<?php

namespace Ignite\Catalog\Validation\Strategies;

use Ignite\Catalog\Models\Cart;

/**
 * Default validation strategy for vendors without specific requirements
 */
class DefaultValidationStrategy extends AbstractValidationStrategy
{
    /**
     * {@inheritdoc}
     */
    public function getValidationRules(Cart $cart = null, array $context = []): array
    {
        $rules = $this->getBaseRules();

        return $this->filterRulesByCart($rules, $cart);
    }

    /**
     * {@inheritdoc}
     */
    public function getValidationMessages(Cart $cart = null): array
    {
        $messages = $this->getBaseMessages();

        return $this->filterMessagesByCart($messages, $cart);
    }

    /**
     * {@inheritdoc}
     */
    public function supports(string $vendorName): bool
    {
        // Default strategy supports all vendors that don't have specific strategies
        return true;
    }
}
