<?php

namespace Ignite\Catalog\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Ignite\Catalog\Models\Cart;
use Ignite\Catalog\Validation\ValidationStrategyFactory;

class OrderCreateRequest extends FormRequest
{
    /**
     * Authorize the order create request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @param  Cart $cart
     * @return array
     */
    public function rules(Cart $cart)
    {
        $factory = new ValidationStrategyFactory();
        $vendorName = ValidationStrategyFactory::determineVendorName($cart);
        $strategy = $factory->create($vendorName);

        return $strategy->getValidationRules($cart);
    }

    /**
     * The customized messages.
     *
     * @return array
     */
    public function messages()
    {
        // Get cart from the request if available
        $cart = $this->get('cart');

        $factory = new ValidationStrategyFactory();
        $vendorName = ValidationStrategyFactory::determineVendorName($cart);
        $strategy = $factory->create($vendorName);

        return $strategy->getValidationMessages($cart);
    }
}
