# Changelog

## 3.4.10 - 2025-07-11

-- @todo-dan: MAKE SURE TO ADD INFO ABOUT THE UPDATE FOR TICKET WDS-7365! --

### NOTE FOR THE DEVELOPER:

- https://brightspot.atlassian.net/browse/WDS-7365

This only applies if using the Hawk vendor. We may need specific validations for the Hawk vendor orders only, in case later we use other vendors that have different requirements for these cards. Perhaps use a configuration or a Hawk adapter/driver class.

The Hawk API affected by this is SubmitOpenLoopPersonalizedIndividual:
(Prepaid and Reloadable)
https://developer.blackhawknetwork.com/hawkmarketplace/reference/dosubmitopenlooppersonalizedindividual
https://developer.blackhawknetwork.com/hawkmarketplace/docs/placing-prepaid-card-personalized-individual-orders

Some Prepaid cards uses Anonymous instead of PersonalizedIndividual, so the API for that is SubmitOpenLoopAnonymous:
https://developer.blackhawknetwork.com/hawkmarketplace/reference/dosubmitopenloopanonymous (Prepaid Anonymous Bulk)
https://developer.blackhawknetwork.com/hawkmarketplace/docs/placing-prepaid-card-anonymous-orders

Other gift card orders may be affected as well if they are all in the same catalog and shopping basket using the same order form:
https://developer.blackhawknetwork.com/hawkmarketplace/reference/dosubmitclosedlooppersonalized (Giftcard)
https://developer.blackhawknetwork.com/hawkmarketplace/docs/placing-gift-card-individual-orders

https://developer.blackhawknetwork.com/hawkmarketplace/reference/dosubmitegiftindividual  (eGift)
https://developer.blackhawknetwork.com/hawkmarketplace/docs/placing-egift-individual-orders

https://developer.blackhawknetwork.com/hawkmarketplace/reference/dosubmitvirtualindividual (Virtual)
https://developer.blackhawknetwork.com/hawkmarketplace/docs/placing-virtual-prepaid-individual-orders

Ideally, we can make these restrictions on the form as it is being validated on submission, so the user can correct their data if needed.

Hawk documentation states the rules for these fields for each API and order type. However since the form may not know the exact API being used once the card(s) are ordered, we may need to have the rules and validation be based on the catalog and form, instead of the API that will be used.

Since the rules seem similar for each API, we may be able to simplify and assume it is the same for all of them on the form(s).

For example, first name is 25 characters or less and is "Digits 0-9, alpha (a-z, A-Z), space period, comma and hyphen".

Whether you are making the SubmitOpenLoopPersonalizedIndividual or SubmitOpenLoopAnonymous call, we can have one set of of Hawk rules for the form, even if Hawk documents them as separate APIs with their own validation rules.

My advice on the steps are:
- Check what fields are needed on the form(s).
- What are the rules needed by Hawk for those fields for Prepaid orders?
- Do the same rules apply to those fields for Prepaid Anonymous, and so on? Can we have a common ground if they not are the same?
- Implement the generic rules onto the form if it is a Hawk catalog order.

Also, please setup a test environment or instructions for a test environment so we can test and approve this for core more easily. When creating a PR, please provide how to best test as well so it can be approved.


## 3.4.9.2 - 2025-04-25

### Changes
- Hotfix in `OrderConfirmation.php` where the configuration path for the BCC email settings was corrected from `catalog.orders.confirmation_bcc` to `catalog.order.confirmation_bcc`.

### Upgrading
- Add `catalog.order.confirmation_bcc.enabled` and `catalog.order.confirmation_bcc.address` to your `config/catalog.php` if you have not already. Or if you had the incorrect `catalog.orders` then please correct to `catalog.order`.

## 3.4.9.1 - 2025-03-05

### Changes
- Introduced a new `ThirdPartyInfo` class to handle third-party address and tax information. ([WDS-6992](https://brightspot.atlassian.net/browse/WDS-6992))
- Updated `CatalogServiceProvider` to register `ThirdPartyInfo` and refactored configuration handling.
- Updated `config/config.php` to include new environment variables and reorganized company information.
- Added `ServerException` handling in `Base.php` for both Hawk and Tango jobs.
- Improved recipient data parsing by handling potential null values.

### Upgrading
- You should composer upgrade `ignite/hawk` to `1.0.23`.
- Compare `config/config.php` to your program's `config/catalog.php` and merge in the changes:
    - Change `catalog.vendors.hawk.prepaid.test_product_id`
    - Remove `catalog.vendors.hawk.prepaid.tax_id`
    - Add `catalog.vendors.hawk.prepaid.anonymous.bulk.test_product_id`
    - Updated `catalog.vendors.hawk.reloadable.test_product_id`
    - Updated `catalog.vendors.hawk.virtual.test_product_id`
    - Remove `catalog.vendors.hawk.contact`
    - Move `catalog.vendors.hawk.company` to `catalog.vendors.hawk.unsubscribe.hawk.company`
    - Move `catalog.vendors.hawk.address1` to `catalog.vendors.hawk.unsubscribe.address1`
    - Move `catalog.vendors.hawk.city` to `catalog.vendors.hawk.unsubscribe.city`
    - Move `catalog.vendors.hawk.state` to `catalog.vendors.hawk.unsubscribe.state`
    - Move `catalog.vendors.hawk.zip` to `catalog.vendors.hawk.unsubscribe.zip`
    - Move `catalog.vendors.hawk.country` to `catalog.vendors.hawk.unsubscribe.country`
    - Add `catalog.product.types.virtual`
- Either in your `config/catalog.php` or in your `.env` file, set the values for `catalog.vendors.hawk.thirdParty` as needed.
    - Add `catalog.vendors.hawk.thirdParty.company`
    - Add `catalog.vendors.hawk.thirdParty.contact`
    - Add `catalog.vendors.hawk.thirdParty.address1`
    - Add `catalog.vendors.hawk.thirdParty.address2`
    - Add `catalog.vendors.hawk.thirdParty.address3`
    - Add `catalog.vendors.hawk.thirdParty.city`
    - Add `catalog.vendors.hawk.thirdParty.region`
    - Add `catalog.vendors.hawk.thirdParty.postalCode`
    - Add `catalog.vendors.hawk.thirdParty.postalCodeExt`
    - Add `catalog.vendors.hawk.thirdParty.country`
    - Add `catalog.vendors.hawk.thirdParty.taxId`
- You should use `CATALOG_HAWK_THIRDPARTY_TAXID` in your `.env` file instead of adding it to the config file.

## 3.4.8.5 - 2024-08-15

### Changes
- Updated `OrderConfirmation` Email to use config values for bcc field.
- Added the environment variables `CATALOG_ORDER_CONFIRMATION_BCC_ENABLED` and `CATALOG_ORDER_CONFIRMATION_BCC_ADDRESS`.

### Upgrading
- Add the environment variables `CATALOG_ORDER_CONFIRMATION_BCC_ENABLED` and `CATALOG_ORDER_CONFIRMATION_BCC_ADDRESS` if needed to your `.env` file.
- Add to your `config/catalog.php` to be in sync with `config/config.php`:
```php
'order' => [
    // ....
    'confirmation_bcc' => [
        'enabled' => env('CATALOG_ORDER_CONFIRMATION_BCC_ENABLED', true),
        'address' => env('CATALOG_ORDER_CONFIRMATION_BCC_ADDRESS', env('MAIL_FROM_ADDRESS', 'itlogs@brightspot.email'))
    ],
],
```

## 3.4.8.4 - 2024-06-21

### Changes
- Added a new property `purchaseOrderNumber` to the `OrderRequest` class. ([WDS-5832](https://brightspot.atlassian.net/browse/WDS-5832))
- A bug where it was using Flash::allowHtml() but may not be using the latest flash package.
- Allow `OrderConfirmation` to overwrite the subject more easily when extending it, without having to overwrite the whole build() method.

### Upgrading
- Upgraded `ignite/tango-api` required from `^1.0.0` to `^1.1`.
- Upgraded `ignite/flash` required to `^1.1.8`.

## 3.4.8.3 - 2024-06-06

### Changes
- Updated default `src/Console/data/tango/egifts.xlsx` with new Royal Caribbean card attributes. ([WDS-5701](https://brightspot.atlassian.net/browse/WDS-5701))

## 3.4.8.2 - 2024-04-05

### Changes
- Hotfix to allow item `hasUrl()`/`getUrl()` for `giftcard`, `prepaid`, and `prepaid.anonymous.bulk`, as they have been missing.
- Added `financialAccountId` to the `Egift`, `Giftcard`, `Prepaid`, and `PrepaidAnonymousBulk` classes as well.

## 3.4.8 - 2024-03-27

### Changes
- Allow different reloadable cards for different countries (US and CA for now - one each).
- Enhanced `ReloadableThreshold` to support fetching SKU based on user's country and added a method to get the card's country.
- Included country in `vendor_meta` for reloadable cards in `reloadable.json`.
- Added `sku_us` and `sku_ca` configurations for reloadable cards in `config.php`.
- Modified `ReloadableController` to improve address handling logic.

### Upgrading
- Update your `config/catalog.php` with the new `catalog.vendors.hawk.reloadable.sku_us` and `catalog.vendors.hawk.reloadable.sku_ca` configurations.
- If you have a custom `ReloadableController`, you may need to update it to handle the new address logic.
- You may want to update `ignite/theme-default` to version `3.2.5` or later.

## 3.4.7 - 2024-03-08

### Changes
- Added a new configuration option `financialAccountId` (FAID) in `config/config.php` for the Hawk reloadable feature. ([WDS-5293](https://brightspot.atlassian.net/browse/WDS-5293))
- Implemented a method `getFinancialAccountId()` in `src/Jobs/Hawk/Base.php` which gets it from the item vendor meta or from the config.
- Modified `Reloadable.php` to include financialAccountId in the data sent.

### Upgrading
- Upgrade to at least version `1.0.22` of `ignite/hawk-api`.
- Update your `config/catalog.php` if needed for `catalog.vendors.hawk.reloadable.financialAccountId` and `CATALOG_HAWK_RELOADABLE_FINANCIAL_ACCOUNTID`.

## 3.4.6.1 - 2024-02-15

### Changes
- File `egifts.xlsx` updated with latest info from Tango and correct descriptions.
- `CatalogItemImportCommandAbstract.php`: Modified the logic for determining the denomination used in price and cost calculations. Now, it checks for an amount in vendor_meta before defaulting to cost or price. This change aims to provide more accurate markup calculations.
- `ReloadableThreshold.php`: Refactor in the methods for converting points to dollars and vice versa, including handling for different currencies (though currency conversion is not yet supported). Deprecated the hasNotCreatedCardButHasEnoughPoints method, indicating a shift in the logic for determining eligibility for card creation based on points.
- `OrderReport.php`: Added new column for vendor_order_numbers to the order report.

## 3.4.6 - 2024-02-11

### Changes
- Updated `TangoImport.php` and `CatalogItemImportCommandAbstract.php` to be able to include different markup alongside each denominations and UTIDs.
- Adjusted `Item.php` to fix the retrieval of a super item from a simple item.
- Bug fix in `ProcessManager.php` to handle cases where an order item's category is not directly associated, looking up through the super item if necessary.
- Implementation in `ReloadableController.php` to adjust price calculation based on markup and costs.
- Expanded explanation in `config.php` regarding the `CATALOG_HAWK_RELOADABLE_ID_PREFIX` configuration, advising against using project codes as they change annually.

### Upgrading
- Update your `config/catalog.php` if needed for the comments about `CATALOG_HAWK_RELOADABLE_ID_PREFIX`.

## 3.4.5 - 2023-12-19

### Changes
- Reloadable cards can have a markup value now. The `ReloadableController` applies the markup value to the card amount.
- The min amount and current amount now reflects the points based on the markup.
- Add `exchange_to_usd` to Catalog Item Form to display, and fix some config on that page.

### Upgrading
- For your reloadable card, make sure your price_markup field for your card is either 0 for no markup, or some decimal number (like 0.10 for 10% markup).
- You may want to update `ignite/theme-default` to version of 3.2.4 or later.

## 3.4.4.2 - 2023-11-21

### Changes
- Hot Fix: Tango/Hawk import was applying the markup twice for points based on the costs!
- Hot Fix: In Tango Import, it was inconsistent between using msrp_us/cost_us/price_us and msrp_usd/cost_usd/price_usd.
- Added more checks on catalog import to warn if the price or points are unexpected.
- Update the Hawk/Tango import command default parameters.
- Fix import for the default Tango excel file, mostly in regards to custom denominations.
- Remove LMH configurations from Tango and using environment TANGO variables now.
- Alow the catalog imports to look at the base_path() as well, to allow more relative path.

### Upgrading
- **NOTE:** If you had a catalog import since 10/6, please check if your point values included markup twice! If so, you may need to recalculate the price and points of each card, or re-run the import.
- If you have a Tango import Xlsx file, make sure to rename the columns `msrp_us`, `cost_us`, and `price_us` to `msrp_usd`, `cost_usd`, and `price_usd` respectively. See the `Catalog\src\Console\data\tango\egifts.xlsx` file as an example.
- In your `config/catalog.php` file, you could update your `catalog.vendors.tango.sender` with this:
```php
'sender' => [
    'email' => env('CATALOG_TANGO_SENDER_EMAIL', env('CATALOG_EMAIL', env('MAIL_FROM_ADDRESS', 'it@brightspot.email'))),
    'firstname' => env('CATALOG_TANGO_SENDER_FIRST', env('APP_NAME', 'Ignite Catalog Rewards')),
    'lastname' => env('CATALOG_TANGO_SENDER_LAST'),
],
```

## 3.4.4.1 - 2023-10-06

### Changes
- Hot Fix: Fixes for the catalog imports, especially for default reloadables.

## 3.4.4 - 2023-10-02

### Changes
- Fixed the checkout now button in our flash message that is sent after adding an item to the cart.

## 3.4.3 - 2023-08-11

### Changes
- Added `internal_name` to Catalogs. Now when editing Catalogs we will see the `internal_name` instead of the `name` if it has been set. ([WDS-2786](https://brightspot.atlassian.net/browse/WDS-2786))

### Upgrading
- Running migrations will add the new field `internal_name` to `catalog`.
- If you have replaced any of the following files in your program, you may need to merge in the changes:
    - `resources/lang/en/catalog.php`
    - `src/Entities/Catalog.php`
    - `src/Http/Forms/CatalogForm.php`
    - `src/Models/Grid/CatalogsTable.php`
    - `src/Models/Options/Catalog.php`

## 3.4.2 - 2023-08-08

### Changes
- Updates to `src/Http/Controllers/ReloadableController.php` and `src/Models/ReloadableThreshold.php` for reloadable cards, to clean up some flash messages and interfaces. ([WDS-3932](https://brightspot.atlassian.net/browse/WDS-3932))
- Some updates to how error messages from vendor are caught, and are no longer being truncated!
- Some updates to how error messages from vendor are displayed in emails and on-screen.

### Upgrading
- You may need to update the default theme to 3.2.2 as well.

## 3.4.1 - 2023 07-26

### Changes
- Updated Hawk config variables to use .env variables instead of hardcoding values. ([WDS-3931](https://brightspot.atlassian.net/browse/WDS-3931))
- New .env variables:
    - `CATALOG_HAWK_EGIFT_SENDER_NAME`
    - `CATALOG_HAWK_EGIFT_SENDER_EMAIL`
    - `CATALOG_HAWK_EGIFT_SUBJECT`
    - `CATALOG_HAWK_VIRTUAL_SENDER_NAME`
    - `CATALOG_HAWK_VIRTUAL_SENDER_EMAIL`
    - `CATALOG_HAWK_VIRTUAL_SUBJECT`
    - `CATALOG_HAWK_COMPANY_NAME`
    - `CATALOG_HAWK_COMPANY_CONTACT_NAME`
    - `CATALOG_HAWK_UNSUBSCRIBE_EMAIL`

## 3.4.0 - 2023-07-03

### Changes
- Use of Tango API to the Tango catalog now.

### Upgrading
- The `ignite/tango-api` is now a requirement.
- Update `ignite/theme-default` to at least version `3.2.1` to get the latest blade files for these updates.
- See the config variables for Tango in `config/config.php` and merge into your `config/catalog.php` if needed.
- If you have previously replace the `resources/views/admin/orders/items/inspect.blade.php` file for your own program theme folder, you may need to re-sync that file.
- Some of the files that were modified that you may want to check if you have replaced in your program, and should merge in the changes:
    - Console / Seeder / Import
        - `database/data/catalog.json`
        - `src/Console/CatalogItemImportCommandAbstract.php`
        - `src/Console/Hawk.php`
    - Controllers
        - `src/Http/Controllers/Admin/OrderItemsController.php`
        - `src/Http/Controllers/CartController.php`
    - General
        - `src/Emails/OrderConfirmation.php`
        - `src/Entities/CartItem.php`
        - `src/Entities/Item.php`
        - `src/Presenters/ItemPresenter.php`
    - Hawk
        - `src/Jobs/Hawk/Base.php`
        - `src/Jobs/Hawk/Egift.php`
        - `src/Jobs/Hawk/Giftcard.php`
        - `src/Jobs/Hawk/Prepaid.php`
        - `src/Jobs/Hawk/ProcessManager.php`
        - `src/Jobs/Hawk/Virtual.php`
        - `src/Jobs/ProcessManager.php`
        - `src/Listeners/RequestHawkOrderInfo.php`
        - `src/Vendors/Hawk/Egift.php`
        - `src/Vendors/Hawk/Giftcard.php`
        - `src/Vendors/Hawk/Prepaid.php`
        - `src/Vendors/Hawk/PrepaidAnonymousBulk.php`
        - `src/Vendors/Hawk/Processor.php`
        - `src/Vendors/Hawk/Reloadable.php`
        - `src/Vendors/Hawk/Virtual.php`
        - `src/Vendors/VendorHandler.php`
- Other files modified to be aware of:
    - `src/Providers/CatalogServiceProvider.php`
    - `src/Providers/ConsoleServiceProvider.php`
    - `src/Providers/EventServiceProvider.php`
    - `src/Repositories/CartRepository.php`
    - `src/Repositories/ItemRepository.php`
    - `src/Repositories/OrderRepository.php`

## 3.4.0 - 2023-07-03

### Changes
- Use of Tango API to the Tango catalog now.

### Upgrading
- The `ignite/tango-api` is now a requirement.
- Update `ignite/theme-default` to at least version `3.2.1` to get the latest blade files for these updates.
- See the config variables for Tango in `config/config.php` and merge into your `config/catalog.php` if needed.
- If you have previously replace the `resources/views/admin/orders/items/inspect.blade.php` file for your own program theme folder, you may need to re-sync that file.
- Some of the files that were modified that you may want to check if you have replaced in your program, and should merge in the changes:
    - Console / Seeder / Import
        - `database/data/catalog.json`
        - `src/Console/CatalogItemImportCommandAbstract.php`
        - `src/Console/Hawk.php`
    - Controllers
        - `src/Http/Controllers/Admin/OrderItemsController.php`
        - `src/Http/Controllers/CartController.php`
    - General
        - `src/Emails/OrderConfirmation.php`
        - `src/Entities/CartItem.php`
        - `src/Entities/Item.php`
        - `src/Presenters/ItemPresenter.php`
    - Hawk
        - `src/Jobs/Hawk/Base.php`
        - `src/Jobs/Hawk/Egift.php`
        - `src/Jobs/Hawk/Giftcard.php`
        - `src/Jobs/Hawk/Prepaid.php`
        - `src/Jobs/Hawk/ProcessManager.php`
        - `src/Jobs/Hawk/Virtual.php`
        - `src/Jobs/ProcessManager.php`
        - `src/Listeners/RequestHawkOrderInfo.php`
        - `src/Vendors/Hawk/Egift.php`
        - `src/Vendors/Hawk/Giftcard.php`
        - `src/Vendors/Hawk/Prepaid.php`
        - `src/Vendors/Hawk/PrepaidAnonymousBulk.php`
        - `src/Vendors/Hawk/Processor.php`
        - `src/Vendors/Hawk/Reloadable.php`
        - `src/Vendors/Hawk/Virtual.php`
        - `src/Vendors/VendorHandler.php`
- Other files modified to be aware of:
    - `src/Providers/CatalogServiceProvider.php`
    - `src/Providers/ConsoleServiceProvider.php`
    - `src/Providers/EventServiceProvider.php`
    - `src/Repositories/CartRepository.php`
    - `src/Repositories/ItemRepository.php`
    - `src/Repositories/OrderRepository.php`

## 3.3.0 - 2023-06-15

### Changes
- Added UI for reloadable card, added some config variables, added `hawk-reloadable` as a new catalog vendor type.
- Added two routes to handle reloadable card, one to get to the form and another to post the reloadable submission along with their own controller `ReloadableController`.([WDS-3881](https://brightspot.atlassian.net/browse/WDS-3881)
- Added some config variables to handle reloadable constraints
- Added `hasUrl()` and `getUrl()` to `Item` and `ItemRepository` to handle a bug where if a catalog item does not have a (appropriate) link to the item, then it should not link to another page.

### Upgrading
- Please update `ignite/theme-default` to at least version `3.2.0` to get the latest blade files for these updates.
- If you have previously replace the `views/catalog/index.blade.php` or `views/catalog/order/show.blade.php` files or any blades in the `views/catalog/reloadable/` folder for your own program theme folder, you may need to re-sync those files.
- The seeder should add a new vendor type.
- If your program already has a custom UI/Controller/routes, that could be removed to handle with this addition using the defined routes:
    - route to get the reloadable form: `catalog.hawk-reloadable`
    - route to post the form: `catalog.hawk-reloadable-store`
- The config variables can be changed based on your program's requirements. The following values as well as in the config file of the module are for representation purpose only:

```php
<?php

'vendors' => [
    'hawk' => [
        'reloadable' => [
            ...
            // if we want to maintain the min threshold
            'min_threshold_initial' => 5,
            'min_threshold_reload' => 5,
            'sku' => 'visa_reloadable_us'
            ...
        ]
    ]
]
```

## 3.2.0 - 2023-06-08

### Changes
- Repurposed Inspect button in order details page to get Hawk order status details ([WDS-3877](https://brightspot.atlassian.net/browse/WDS-3877))

## 3.1.0 - 2023-06-06

### Changes
- Added Tango vendor and catalog (as well as Hawk Reloadable catalog)
- Added MX to catalogs available in seeders.
- Added fields and imports for Tango cards. Also includes a starter Tango egift.csv import file.

### Upgrading
- The migration should add the new fields `exchange_to_usd` and `disclaimer` to `catalog_item`.
- Catalog module now has automatic seeder, reading from `vendor/ignite/modules/Catalog/database/data`, but you can replace with files in your `modules/Program/database/data` folder.

## 3.0.29 - 2023-05-04

### Changes
- Added `poNumber` in the payload for Hawk virtual cards ([WDS-3871](https://brightspot.atlassian.net/browse/WDS-3871)

## 3.0.28 - 2023-04-14

### Changes
- If a hawk order is incomplete, it now tries to retrieve an order info based on the `order_number` or `client_program_number` and `requestId`.
- It tries to pull the `vendor_order_number` column that was added as part of the previous changes ("3.0.27 - 2023-03-20"), but it also has a fallback to get the order number from the metadata as well.
- Added a method `processOrderInfo()` that is called with in the `handle()` method of `RequestHawkOrderInfo` class. ([WDS-3785](https://brightspot.atlassian.net/browse/WDS-3785) | ([WDS-3061](https://brightspot.atlassian.net/browse/WDS-3061)

## 3.0.27 - 2023-03-20

### Changes
- On ordering for Hawk, it now stores the order number and category into the `catalog_order_item` table. ([WDS-3735](https://brightspot.atlassian.net/browse/WDS-3735))
- The new fields `vendor_order_number` and `category` now show on some reports.
- Updated `php-lint` and `php-code-sniffer` in composer. Ran `php-code-beautify` on files.

### Upgrading
- The migration should add the new fields `vendor_order_number` and `category` to `catalog_order_item`, if they do not exist already.
- The migration will also migrates data from existing Hawk orders into those new fields.
- If your program has updated or replaced the `Ignite\Catalog\Models\Grid\OrderItemTable` or `Ignite\Catalog\Models\Report\OrderItemReport` classes, you may want to reconcile with the recent column changes.
- If your program has updated or replaced the `Ignite\Catalog\Jobs\Hawk\ProcessManager` class, you may want to reconcile with the recent changes.
- For certain programs (like Avaya Edge), this may mean:
    - Renaming the `category_name` to `category` and in reports.
    - Optionally, moving `vendor_order_number` from `catalog_order` to `catalog_order_item`.

## 3.0.26 - 2023-01-16

### Changes
- Update `Ignite\Catalog\Jobs\Hawk\Reloadable` so that it is not abstract anymore and can be used. ([WDS-3588](https://brightspot.atlassian.net/browse/WDS-3588))
- Update configurations for reloadables. Added a migration to `core_participant` for new fields if it did not already exists.

### Upgrading
- The migration should add the new fields `reloadable_id` and `reloadable_created_at` to `core_participant`.
- Update your `config/catalog.php` to match with `catalog/config/config.php` in the `vendors.hawk.reloadable` section, and customize as needed for your program.

## 3.0.25 - 2023-01-10

### Changes
- Updated entity (Catalog) to display `created_at` and `updated_at` datetimes in `Y-m-d H:i:s` format. ([WDS-3274](https://brightspot.atlassian.net/browse/WDS-3274))

## 3.0.24 - 2022-12-14

### Changes
- Added Ship Email column to Order Report 
- Added Ship Email column to Order Item Report

## 3.0.23 - 2022-12-06

### Changes
- Bug fixes: Whole orders were being canceled if one line item being canceled has the same quantity as the number of products (not quantity) in the order. This is usually because of how we save order quantity from Helix. Rather, we should check if all items in the order are canceled, and ignore catalog_order.quantity.

## 3.0.22 - 2022-11-23

### Changes
- Bug fixes: catalog_cart_item.status update not thoroughly flushed out. Several other methods need to account for using only active cart items, like total().
    - While it may fix many bugs with two separate shopping carts, there may be still some bugs especially if two tabs are opened. For instance, if two tabs are both in the checkout page for each cart, then submitting one could end up ordering from the other cart if the other cart was the last one that was "active". This hopefully is a rare situation and can be addressed later.
- Model/Cart attributes are now protected again instead of public. I will update in TTL Rewards accordingly to no longer expect these public attributes.
- Bug fixes: Fix NullProcessor to actually do nothing and not cause error. I guess it was never really used?
- Now when there is an Exception in InteractWithVendor, it logs as an error instead of as a debug, so it can be reported to Flare, and logged even if debug is turned off.

## 3.0.20 - 2022-09-21

### Changes
- Added a status column on catalog_cart_item table, updated cart model to pull only active items from the cart.
- Made properties in Cart public.

## 3.0.17 - 2022-07-22

### Changes
- Fix the command `ignite:catalog:order-check` so that it does not send email if there is nothing to process.
- Fix OrderReport and OrderItemReport: should not be displaying SSN, total on OrderReport is misleading, remove the fixed sorting, and making some other improvements.
- In `config/config.php`: I am pretty sure 'prepaidanonymousbulk' is suppose to be 'prepaid.anonymous.bulk' as the default configuration because that is the type stored in the database, how it is referenced in `Ignite\Catalog\Vendors\Hawk\Processor`, and how it is setup on one of our sites.

### Upgrading
- For OrderReport, you should not be referencing the 'total' field, but if you are, you may want to remove it because it may be inaccurate.

## 3.0.16 - 2022-05-31

### Changes
- Added Virtual to Hawk Vendors, Processor, and Jobs. Updated Item Entity and configuration file ([WDS-2570](https://brightspot.atlassian.net/browse/WDS-2570))

### Upgrading
To enable virtual cards (e.g. Virtual Mastercard) to an existing project, ensure the following has been added to catalog configuration file. 
```php
app\config\catalog.php

[
    ...
    'vendors' => [
        'hawk' => [
            ...
            'virtual' => [
                'enabled' => env('CATALOG_HAWK_VIRTUAL_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_VIRTUAL_TEST_ID', '43479508'),
                'payment_type' => env('CATALOG_HAWK_VIRTUAL_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'senderName' => 'Ignite Rewards',
                'senderEmail' => 'it@brightspot.email',
                'subject' => 'Catalog Rewards - Virtual Order',
                // emailMessage - this cannot exceed 1024 characters
                // these tokens can be included: {first name}, {last name}, {amount}, and {email address}
                'emailMessage' => env('CATALOG_HAWK_VIRTUAL_MESSAGE', ''),
                'emailClosingName' => 'Reward Headquarters',
            ],
            ...
        ],
    ],
]
```

## 3.0.15 - 2022-05-25

### Changes
- [X] Fixed `PrepaidAnonymousBulk::buildOrderLines()` so that the request will have only 1 line item since quantity is already built into the order line as an attribute. When the quantity is 3, it should order 1 item with quantity of 3, instead of 3 items each with a quantity of 3.
- [X] The catalog_favorite table has the super_id field default as 1, which should be default as null instead. When adding a favorite, it does not specify a super id, so it defaults to 1 incorrectly. And worst, if there is no catalog_item with id #1, then it has an error and you can not favorite the item.
- [X] Now when adding to a catalog favorite item, it should correctly get the super item id as well - no matter the default.
- [X] In Jobs/Hawk/Prepaid, the address.line1 should be reading from `catalog.vendors.hawk.address1` and not just `catalog.vendors.hawk.line1` since `catalog.vendors.hawk.address1` is that is in the config file.

### Upgrading
- You may want to selectively merge the latest copy of `config/config.php` into your `config/catalog.php`, especially with the new comments and `vendors.hawk.contact` default value.

## 3.0.14 - 2022-05-16

### Changes
- Removed formatter that formatted the number of digits after decimals except for points and price value on a catalog item.

## 3.0.13 - 2022-05-15

### Changes
- Updated `Jobs\Hawk\Base::getPaymentType()` to ensure the `vendor_meta['payment_type']` is checked against `Ignite\Vender\Hawk\PaymentType::getPaymentTypes()` array values or keys. This should ensure backward compatibility with other programs that only checked against the values.

## 3.0.10 - 2022-05-05

### Changes
- Updated Shipping Methods to reflect Brightspot's current default shipping methods ([WDS-2580](https://brightspot.atlassian.net/jira/software/c/projects/BSDP/boards/28?modal=detail&selectedIssue=WDS-2580))

### Upgrading
- If experiencing issues with `orderDetails.shippingMethod.invalid` check the catalog configuration file to ensure the shipping methods match the following defaults in Hawk Marketplace for the specified endpoint and Hawk product id. Refer to Hawk's [documentation](https://developer.blackhawknetwork.com/hawkmarketplace/docs/welcome)

```php
app\config\catalog.php

[
    ...
    'vendors' => [
        'hawk' => [
            'prepaid' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
            'reloadable' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
    ...
]
```

##  3.0.10.* - Added New Feature
- [F] Added SubmitOpenLoopAnonymousBulk Prepaid API End Point

## 3.0.9
- [X] Define user id for an order being cancel.

## 3.0.8
- [X] Return empty string, if item on a given orderItem does not exist.

## 3.0.7
- [F] Remove numeric characters from the shipping name. Hawk order fails with their existence.

## 3.0.6
- [F] Clean up the last name from ship-email in Hawks' eGift card order. Do not exceed the lastname characters by 30.

## 3.0.5
- [F] Core's points translation can be pluralized now. Updated code here for that update there.

## 3.0.4
- [F] Added OrderPermissionFilter. See ignite/core's version 3.0.30.

## 3.0.3
- [F] Added CATALOG_HAWK_TEST_MODE, which by defaults depends on the environment, but you can overwrite if you want to NOT test in local.
- [F] CATALOG_HAWK_CERT and CATALOG_HAWK_KEY are now auto-detected based on CATALOG_HAWK_TEST_MODE, so you do not need it in your .env
- [X] Removed distinct() from some queries because it may be hiding some bugs. Your query should return distinct values anyway and not need distinct() on most occasions. But if there are duplicate values or rows, then the distinct() could be hiding duplicate rows in the database or a bad join, and we need to see those instead not knowing of their existence.
- [X] It references the wrong class; the class GiftCard does not exists but Giftcard does.
- [X] Points fields are now double instead of decimal(10,4) so we can allow for million of points. All points fields should be the consistent type.

## 3.0.1
- [F] The JSON files for the seeders now can be replaced using the config config('core.seeder.path'). You can now have both core_page.json and core_page_catalog.json replacement files in your Program database/data folder without needing to create new seeder classes.
- [B] If you have existing db records for the catalog, then re-running the seeders may be overwrite those with the new defaults. You may want to create replace the default JSON files with your own in Program.
- [F] Several new composer scripts are available, including: php-security-checker, dos2unix, php-lint, php-code-beautify, php-code-style, and php-copy-paste-detector.