<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Support\HtmlString;
use Ignite\Core\Models\Grid\Formatter;

class CategoryFormatter extends Formatter
{
    /**
     * Format a checkbox for selecting entries in the grid.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        return $this->formatCheckbox($model->id);
    }

    /**
     * Custom column for actions.
     *
     * @param  \Ignite\Catalog\Entities\Order $model
     * @return HtmlString
     */
    public function actions($model)
    {
        $actions = [
            [
                'icon' => 'pencil',
                'label' => trans('Core::core.buttons.edit'),
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.categories.edit', [
                    'category' => $model->id
                ])
            ],
            [
                'icon' => 'eye',
                'label' => trans('Core::core.buttons.view'),
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.categories.show', [
                    'category' => $model->id
                ])
            ],
        ];

        return $this->html($this->buttons($actions));
    }

    /**
     * Format an image.
     *
     * @param  \stdClass $model
     * @return HtmlString
     */
    public function image($model)
    {
        return $this->html($model->image ?? trans('Core::core.common.none'));
    }

    /**
     * Format an icon.
     *
     * @param  \stdClass $model
     * @return HtmlString
     */
    public function icon($model)
    {
        if (! $model->icon) {
            return $this->html(trans('Core::core.common.none'));
        }

        return $this->html(sprintf(
            '<span class="fa-solid %1$s"></span> %1$s',
            $model->icon
        ));
    }

    /**
     * Format whether a category is active.
     *
     * @param  \stdClass $model
     * @return HtmlString
     */
    public function active($model)
    {
        return $this->html($this->formatYesNo(optional($model)->active));
    }
}
