@extends('Catalog::layouts.master')

@section('page_heading', trans('Catalog::vendor.misc.index.heading'))
@section('page_breadcrumb', trans('Catalog::vendor.misc.index.heading'))

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <div class="box box-primary">
                <div class="box-body">
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                    <form id="vendors-delete-form" action="{{ route('admin.catalog.vendors.destroyMany') }}" method="post">
                        {{ csrf_field() }}
                        {{ method_field('DELETE') }}
                        <input type="hidden" name="ids" value="" id="vendors-delete-field" />
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    text: '<span class="fa-solid fa-plus text-success"></span> <span class="text-success">{{ trans('Core::core.buttons.create') }}</span>',
                    action: function (e) {
                        e.preventDefault();
                        window.location.href = '{{ route('admin.catalog.vendors.create') }}'
                    }
                }, {
                    enabled: false,
                    text: '<span class="fa-solid fa-trash text-danger"></span> <span class="text-danger">{{ trans('Core::core.buttons.delete') }}</span>',
                    action: function (e, dt, node, conf) {
                        var selected = dt.column(0).checkboxes.selected();
                        var message = "{{ trans('Catalog::vendor.delete_many.confirm') }}";
                        if (confirm(message)) {
                            $('#vendors-delete-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                            $('#vendors-delete-form').submit();
                        }
                    }
                }]
            });

            // Delete click handler
            $.deleteEntry({
                confirmation: "{{ trans('Catalog::vendor.delete.confirm') }}",
                request: { method: 'GET', type: 'json' },
                onSuccess: function(button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function() {
                            $(this).remove();
                            $dataTable.DataTable().ajax.reload();
                        });
                }
            });
        });
    </script>
@endsection
