{!! form_start($form) !!}
<div id="item-app" class="row">
    <div class="col-sm-4 pull-right">
        @component('Core::admin.components.box', ['classes' => ($form->isSimple() ? '' : 'hide')])
            <label class="form-control">Constrain pricing?<input class="pull-right" id="contrain-pricing" type="checkbox" checked /></label>

            {!! form_row($form->msrp) !!}
            {!! form_row($form->cost) !!}
            {!! form_row($form->price) !!}
            {!! form_row($form->point_value) !!}
            {!! form_row($form->exchange_to_usd) !!}
            {!! form_row($form->points) !!}
            {!! form_row($form->price_margin) !!}
            {!! form_row($form->price_markup) !!}
        @endcomponent
        @component('Core::admin.components.box')
            {!! form_row($form->categories) !!}
        @endcomponent
        @component('Core::admin.components.box')
            @if (isset($item) && $item->image)
                <img src="{{ $item->getImageUrl() }}" class="img-responsive" alt="{{ $item->name }}" />
                <hr />
            @endif
            {!! form_row($form->image, ['attr' => ['class' => 'filestyle']]) !!}
        @endcomponent
        @if (isset($item) && count($form->vendor_meta->getFields()) > 0)
        @component('Core::admin.components.box')
            {!! form_row($form->vendor_meta) !!}
        @endcomponent
        @endif
        @component('Core::admin.components.box')
            {!! form_row($form->visibility) !!}
            {!! form_row($form->active) !!}
            {!! form_row($form->vendor_active) !!}

            @slot('footer')
                <div class="pull-left">
                    <input type="submit" name="back" value="Save" class="btn btn-default" />
                </div>
                <div class="pull-right">
                    {!! form_row($form->submit) !!}
                </div>
            @endslot
        @endcomponent
    </div>
    <div class="col-sm-8 pull-left">
        @component('Core::admin.components.box')
            {!! form_rest($form) !!}
        @endcomponent

        @if ($form->isConfigurable() && isset($item))
            @component('Core::admin.components.box')
                @slot('title', trans('Catalog::item.misc.attributes.configure'))

                <div id="catalog-attributes">
                    <catalog-attributes @selected="updateHiddenField" sku="{{ $item->sku }}" :item="{{ $item->getKey() }}"></catalog-attributes>
                </div>
            @endcomponent
        @endif
    </div>
</div>
{!! form_end($form, false) !!}
