(function(jQuery, window, document, undefined) {

  'use strict';

  jQuery(document).ready(function ($) {
    // Image upload
    $(".filestyle").filestyle({
      placeholder: 'Choose an image',
      text: 'Browse',
      theme: "blue",
      btnClass: 'btn-default',
      htmlIcon: '<span class="fa-solid fa-folder"></span> '
    });

    // SKU auto-fill
    var $name = $('#name');
    var $code = $('#sku');

    if (! $code.attr('disabled') && !$code.attr('readonly')) {
      $name.on('keyup', function() {
        $code.val(
          $.trim($name.val())
            .toLowerCase()
            .replace(/[^a-z0-9]+|\s+/gmi, '_')
            .replace(/[\-]+$/g, '')
        );
      });
    }

    // Price Margin
    $('#price_margin').calculator({
      field: 'margin'
    });

      // Price Markup
    $('#price_markup').calculator({
      field: 'markup'
    });
  });

})(jQuery, window, document);
