@extends('Catalog::layouts.master')

@section('page_breadcrumb', trans('Catalog::item.misc.index.heading'))
@section('page_heading', trans('Catalog::item.misc.index.heading'))

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="{{ request()->input('visibility') == '' ? 'active' : '' }}">
                        <a href="{{ route('admin.catalog.items.index') }}">{{ trans('Catalog::item.misc.index.tab.all') }}</a>
                    </li>
                    <li class="{{ request()->input('visibility') == '1' ? 'active' : '' }}">
                        <a href="{{ route('admin.catalog.items.index', ['visibility' => '1']) }}">{{ trans('Catalog::item.misc.index.tab.visible') }}</a>
                    </li>
                    <li class="{{ request()->input('visibility') == '0' ? 'active' : '' }}">
                        <a href="{{ route('admin.catalog.items.index', ['visibility' => '0']) }}">{{ trans('Catalog::item.misc.index.tab.invisible') }}</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <form id="orders-delete-form" action="{{ route('admin.catalog.items.destroyMany') }}" method="post">
                        {{ csrf_field() }}
                        {{ method_field('DELETE') }}
                        <input type="hidden" name="ids" value="" id="orders-delete-field" />
                    </form>
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    enabled: true,
                    text: '<span class="fa-solid fa-plus text-success"></span> <span class="text-success">{{ trans('Core::core.buttons.create') }}</span>',
                    action: function (e) {
                        e.preventDefault();
                        window.location.href = '{{ route('admin.catalog.items.create') }}'
                    }
                }, {
                    enabled: false,
                    text: '<span class="fa-solid fa-trash text-danger"></span> <span class="text-danger">{{ trans('Core::core.buttons.delete') }}</span>',
                    action: function (e, dt, node, conf) {
                        var selected = dt.column(0).checkboxes.selected();
                        var message = "{{ trans('Catalog::item.delete_many.confirm') }}";
                        if (confirm(message)) {
                            $('#orders-delete-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                            $('#orders-delete-form').submit();
                        }
                    }
                }]
            });
        });
    </script>
@endsection
