<?php

namespace Ignite\Catalog\Events;

use Ignite\Catalog\Entities\Order;
use Ignite\Catalog\Entities\OrderItem;
use Ignite\Vendor\Hawk\Response\BaseOrderResponse;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class CompleteHawkOrder
{
    use Dispatchable, SerializesModels;

    /**
     * @var Order
     */
    public $order;

    /**
     * @var OrderItem
     */
    public $orderItem;

    /**
     * @var
     */
    public $response;

    /**
     * @var string
     */
    public $requestId;

    /**
     * Create a new event instance.
     *
     * @param Order $order
     * @param OrderItem $orderItem
     * @param BaseOrderResponse $response
     * @param string $requestId
     */
    public function __construct(Order $order, OrderItem $orderItem, $response, $requestId)
    {
        $this->order = $order;
        $this->orderItem = $orderItem;
        $this->response = $response;
        $this->requestId = $requestId;
    }
}
