<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Catalog\Entities\Vendor;

class CatalogVendorTableSeeder extends AbstractCatalogSeeder
{
    /**
     * The name of the data file.
     *
     * @var string
     */
    protected $file = 'catalog_vendor.json';

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath($this->file)
        ]);

        $vendors = $strategy->run();

        foreach ($vendors as $vendor) {
            try {
                Vendor::query()->updateOrCreate([
                    'name' => $vendor['name'],
                ], $vendor);
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
