<?php

return [
    'catalog' => [
        'heading' => 'Catalog',
        'error' => [
            'unsupported_country' => "Sorry, we don't support your country.",
        ]
    ],
    'general' => [
        'home' => 'Home',
        'catalog' => 'Catalog',
        'cart' => 'Cart',
        'favorites' => 'Favorites',
        'filter' => 'Filter',
        'points' => 'Points',
        'balance' => 'Balance',
        'choose' => 'Choose',
        'item' => 'Item',
        'name' => 'Name',
        'qty' => 'Qty',
        'quantity' => 'Quantity',
        'terms' => 'Terms of Use',
        'disclaimer' => 'Disclaimer',
    ],
    'sidebar' => [
        'search' => [
            'heading' => 'Search',
            'back' => 'Back to Overview',
            'reset' => 'Reset Search',
            'placeholder' => 'Enter keywords...',
            'no_results' => 'Sorry no items found.',
            'no_results_for_keyword' => 'Sorry no items found for search term "<strong>:keyword</strong>".',
        ],
        'sort' => [
            'heading' => 'Sort',
            'options' => [
                'name_asc' => 'Name (Ascending)',
                'name_desc' => 'Name (Descending)',
                'points_desc' => 'Most Points',
                'points_asc' => 'Least Points',
            ]
        ],
        'categories' => [
            'heading' => 'Categories'
        ],
        'buttons' => [
            'apply' => [
                'label' => 'Apply'
            ],
            'reset' => [
                'label' => 'Reset'
            ],
            'cancel' => [
                'label' => 'Cancel'
            ]
        ]
    ],
    'favorite' => [
        'heading' => 'Favorites',
        'empty' => "You haven't added any favorites yet.",
        'item' => [
            'add' => [
                'label' => 'Add to Favorites',
            ],
            'remove' => [
                'label' => 'Remove from Favorites'
            ]
        ],
        'flash' => [
            'add' => [
                'success' => 'Item successfully added to favorites.',
                'exception' => 'Unable to favorite the item.'
            ],
            'remove' => [
                'success' => 'Item successfully remove from favorites.',
                'exception' => 'Unable remove the item from favorites.'
            ]
        ]
    ],
    'cart' => [
        'heading' => 'Cart',
        'empty' => 'Your cart is empty.',
        'continue' => 'Keep Shopping',
        'checkout' => 'Checkout',
        'table' => [
            'item' => 'Item',
            'name' => 'Name',
            'qty' => 'Qty',
            'quantity' => 'Quantity',
            'points' => 'Points',
            'total' => 'Total',
            'available' => 'Available',
            'after' => 'After Order'
        ],
        'item' => [
            'add' => [
                'label' => 'Add to Cart'
            ],
            'view' => [
                'label' => 'View'
            ],
            'update' => [
                'label' => 'Update Cart',
            ],
            'remove' => [
                'label' => 'Remove from Cart',
                'confirm' => 'Are you sure you want to delete this item from your cart?'
            ]
        ],
        'flash' => [
            'add' => [
                'success' => ':item was added to your cart. <a href=":link" class="btn btn-sm btn-default btn-alert">Checkout Now</a>',
                'exception' => 'Unable to add item to cart.'
            ],
            'update' => [
                'success' => 'Your cart was updated successfully.',
                'exception' => 'Unable to update your cart.'
            ],
            'remove' => [
                'success' => ':item was removed from cart.',
                'exception' => 'Unable to remove an item from your cart.'
            ]
        ]
    ],
    'checkout' => [
        'heading' => 'Checkout',
        'form' => [
            'name' => [
                'label' => 'Name'
            ],
            'first_name' => [
                'label' => 'First Name'
            ],
            'last_name' => [
                'label' => 'Last Name'
            ],
            'phone_number' => [
                'label' => 'Phone Number'
            ],
            'email' => [
                'label' => 'Email',
                'help' => [
                    'card' => 'Please enter the email address to which you would like to send your :card.'
                ],
            ],
            'address' => [
                'label' => 'Address'
            ],
            'address1' => [
                'label' => 'Address 1'
            ],
            'address2' => [
                'label' => 'Address 2'
            ],
            'address3' => [
                'label' => 'Address 3'
            ],
            'city' => [
                'label' => 'City'
            ],
            'state' => [
                'label' => 'State'
            ],
            'postal' => [
                'label' => 'Zip/Postal Code'
            ],
            'country' => [
                'label' => 'Country'
            ],
            'is_business_address' => [
                'label' => 'Is this a business address?'
            ],
            'back' => [
                'label' => 'Back to Cart'
            ],
            'submit' => [
                'label' => 'Place Order'
            ]
        ],
        'summary' => [
            'item' => [
                'quantity' => 'Quantity',
                'points' => 'Points',
            ],
            'total' => 'Total Points',
            'available' => 'Available',
            'after' => 'After'
        ],
        'complete' => [
            'heading' => 'Order Complete',
            'greeting' => 'Thank You',
            'message' => 'Your order was submitted successfully. You will receive an email confirmation shortly.',
            'egift' => [
                'message' => 'The eGift :card you ordered will be emailed to <strong>:email</strong> within 24 hours.'
            ],
            'shipping' => [
                'heading' => 'Shipping Information',
            ],
            'contact' => [
                'heading' => 'Contact Information',
            ]
        ],
        'items' => [
            'heading' => 'Items'
        ],
        'flash' => [
            'success' => 'Order placed successfully.',
            'exception' => 'There was an error placing your order.'
        ]
    ],
    'order' => [
        'heading' => 'My Orders',
        'table' => [
            'number' => 'Number',
            'date' => 'Date',
            'items' => 'Items',
            'total' => 'Total',
            'points' => 'Points',
            'button' => [
                'view' => [
                    'label' => 'View'
                ]
            ],
            'empty' => 'No orders found.',
            'search' => [
                'placeholder' => 'Search...'
            ]
        ],
        'detail' => [
            'summary' => [
                'heading' => 'Order'
            ]
        ],
        'validation' => [
            'first' => ['required' => 'First name is required'],
            'last' => ['required'  => 'Last name is required'],
            'email' => [
                'required'  => 'Email address is required',
                'email'  => 'Email address is not valid'
            ],
            'ship_phone' => [
                'required'  => 'Phone number is required',
                'numeric'  => 'Phone number must be numeric'
            ],
            'ship_address_1' => ['required'  => 'Address line 1 is required'],
            'ship_address_2' => ['required'  => 'Address line 2 is required'],
            'ship_city' => ['required'  => 'City is required'],
            'ship_state' => ['required'  => 'State is required'],
            'ship_postal' => ['required'  => 'Postal code/zip is required'],
            'ship_country' => ['required'  => 'Country is required'],
        ]
    ]
];
