<?php

namespace Ignite\Catalog\Tests\Unit\Models\Product\Classifications;

use Ignite\Catalog\Entities\Item;
use Ignite\Catalog\Models\Product\Classifications\Card;
use Ignite\Catalog\Tests\TestCase;

class CardTest extends TestCase
{
    /** @var Card */
    protected $giftcard;

    public function setUp() : void
    {
        parent::setUp();

        $this->giftcard = new Card(new Item());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Classifications
     */
    public function it_is_a_physical_product()
    {
        $this->assertTrue($this->giftcard->isPhysical());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Classifications
     */
    public function it_is_not_a_reloadable_product()
    {
        $this->assertFalse($this->giftcard->isReloadable());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Classifications
     */
    public function it_is_not_an_open_loop_product()
    {
        $this->assertFalse($this->giftcard->isOpenLoop());
    }
}
