<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTangoCardFields extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('catalog_item', function (Blueprint $table) {
            if (!Schema::hasColumn('catalog_item', 'exchange_to_usd')) {
                $table->float('exchange_to_usd')->nullable()->after('price');
            }
            if (!Schema::hasColumn('catalog_item', 'disclaimer')) {
                $table->text('disclaimer')->nullable()->after('terms');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('catalog_item', function (Blueprint $table) {
            $table->dropColumn('exchange_to_usd');
            $table->dropColumn('disclaimer');
        });
    }
}
