<?php

use Ignite\Catalog\Entities\Item;
use Ignite\Catalog\Entities\OrderItem;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCategoryToOrderItem extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('catalog_order_item', 'category')) {
            Schema::table('catalog_order_item', function (Blueprint $table) {
                $table->string('category')->after('class')->nullable();
            });
        }

        $this->migrateItemCategory();
    }

    /**
     * Reverse the migrations.
     *
     * -------------------------------------------------- //
     * Be Careful!
     * -------------------------------------------------- //
     * This may drop data in the category column if it
     * pre-existed before the migration!
     * --------------------------------------------------
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('catalog_order_item', 'category')) {
            Schema::table('catalog_order_item', function (Blueprint $table) {
                $table->dropColumn('category');
            });
        }
    }

    /**
     * Migrate item category.
     *
     * @return void
     */
    protected function migrateItemCategory(): void
    {
        // Do this for Hawk; Helix has its own migration
        $orderItems = OrderItem::query()->whereNull('category')->get();
        foreach ($orderItems as $orderItem) {
            $item = Item::find($orderItem->catalog_item_id);
            if (empty($item)) {
                continue;
            }

            // if there are multiple categories, just get the first one
            $category = $item->categories()->first();
            if (empty($category)) {
                continue;
            }
            $orderItem->update(['category' => $category->name]);
        }
    }
}
